/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.format;

import info.bioinfweb.commons.Math2;

public class DistanceValue
implements Cloneable {
    public static final float POINTS_PER_MM = 2.8346457f;
    private float millimeters = 0.0f;

    public DistanceValue() {
    }

    public DistanceValue(float inMillimeters) {
        this.setInMillimeters(inMillimeters);
    }

    public float getInMillimeters() {
        return this.millimeters;
    }

    public void setInMillimeters(float value) {
        this.millimeters = value;
    }

    public float getInPixels(float pixelsPerMillimeter) {
        return this.millimeters * pixelsPerMillimeter;
    }

    public int getRoundedInPixels(float pixelsPerMillimeter) {
        return Math2.roundUp(this.millimeters * pixelsPerMillimeter);
    }

    public void setInPixels(float value, float pixelsPerMillimeter) {
        this.millimeters = DistanceValue.pixelsToMillimeters(value, pixelsPerMillimeter);
    }

    public float getInPoints() {
        return this.millimeters * 2.8346457f;
    }

    public void setInPoints(float value) {
        this.millimeters = value / 2.8346457f;
    }

    public void assign(DistanceValue other) {
        this.setInMillimeters(other.getInMillimeters());
    }

    public void add(DistanceValue other) {
        this.add(other.getInMillimeters());
    }

    public void add(float addend) {
        this.setInMillimeters(this.getInMillimeters() + addend);
    }

    public static float pixelsToMillimeters(float pixels, float pixelsPerMillimeter) {
        return pixels / pixelsPerMillimeter;
    }

    public static float millimetersToPixels(float mm, float pixelsPerMillimeter) {
        return mm * pixelsPerMillimeter;
    }

    public static float millimetersToPoints(float mm) {
        return mm * 2.8346457f;
    }

    public static float pointsToMillimeters(float pt) {
        return pt / 2.8346457f;
    }

    public DistanceValue clone() {
        try {
            return (DistanceValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.millimeters);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DistanceValue) {
            return this.getInMillimeters() == ((DistanceValue)obj).getInMillimeters();
        }
        return false;
    }
}

