/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.format;

import info.bioinfweb.commons.graphics.FontCalculator;
import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.document.format.ElementFormats;
import info.bioinfweb.treegraph.document.format.TextFormats;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class ConcreteTextFormats
implements ElementFormats,
Cloneable,
TextFormats {
    private String fontName = "Arial";
    private DistanceValue textHeight = new DistanceValue(6.0f);
    private int textStyle = 0;
    private Color textColor = DEFAULT_TEXT_COLOR;
    private Locale locale;
    private DecimalFormat decimalFormat;

    public ConcreteTextFormats() {
        this.setDecimalFormat(new DecimalFormat("0.0#####"), DEFAULT_LOCALE);
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    @Override
    public DistanceValue getTextHeight() {
        return this.textHeight;
    }

    @Override
    public float getDescent() {
        return FontCalculator.getInstance().getDescentToHeight(this.getFontName(), this.getTextStyle(), this.getTextHeight().getInMillimeters());
    }

    @Override
    public boolean hasTextStyle(int style) {
        return (this.textStyle & style) == style;
    }

    @Override
    public int getTextStyle() {
        return this.textStyle;
    }

    @Override
    public void setTextStyle(int style) {
        this.textStyle = style;
    }

    @Override
    public void addTextStyle(int style) {
        this.textStyle |= style;
    }

    @Override
    public void removeTextStyle(int style) {
        this.textStyle &= ~style;
    }

    @Override
    public Font getFont(float pixelsPerMillimeter) {
        float textHeight = this.getTextHeight().getInPixels(pixelsPerMillimeter);
        int style = this.getTextStyle() & 0xFFFFFFFB;
        return new Font(this.getFontName(), style, 1).deriveFont(FontCalculator.getInstance().getFontSizeByTextHeight(textHeight, this.getFontName(), style));
    }

    @Override
    public Color getTextColor() {
        return this.textColor;
    }

    @Override
    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
        this.locale = (Locale)locale.clone();
    }

    @Override
    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    @Override
    public void setDecimalFormat(DecimalFormat decimalFormat, Locale locale) {
        if (decimalFormat == null || locale == null) {
            throw new IllegalArgumentException("The decimal format or the locale cannot be null.");
        }
        this.decimalFormat = (DecimalFormat)decimalFormat.clone();
        this.setLocale(locale);
    }

    @Override
    public void assignTextFormats(TextFormats other) {
        this.setFontName(other.getFontName());
        this.getTextHeight().assign(other.getTextHeight());
        this.setTextStyle(other.getTextStyle());
        this.setTextColor(other.getTextColor());
        this.setDecimalFormat(other.getDecimalFormat(), other.getLocale());
    }

    @Override
    public ConcreteTextFormats clone() {
        ConcreteTextFormats result = new ConcreteTextFormats();
        result.assignTextFormats(this);
        return result;
    }
}

