/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.format;

import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.document.format.ElementFormats;
import info.bioinfweb.treegraph.document.format.LineFormats;
import java.awt.Color;

public class BranchFormats
implements ElementFormats,
LineFormats,
Cloneable {
    public static final boolean STD_CONSTANT_WIDTH = false;
    public static final float DEFAULT_MIN_LENGTH = 4.0f;
    public static final float STD_MIN_SPACE_ABOVE = 0.0f;
    public static final float STD_MIN_SPACE_BELOW = 0.0f;
    private Color lineColor = LineFormats.DEFAULT_LINE_COLOR;
    private DistanceValue lineWidth = new DistanceValue(0.3f);
    private boolean constantWidth = false;
    private DistanceValue minSpaceAbove = new DistanceValue(0.0f);
    private DistanceValue minSpaceBelow = new DistanceValue(0.0f);
    private DistanceValue minLength = new DistanceValue(4.0f);

    @Override
    public DistanceValue getLineWidth() {
        return this.lineWidth;
    }

    public DistanceValue getMinLength() {
        return this.minLength;
    }

    public DistanceValue getMinSpaceAbove() {
        return this.minSpaceAbove;
    }

    public DistanceValue getMinSpaceBelow() {
        return this.minSpaceBelow;
    }

    @Override
    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public boolean isConstantWidth() {
        return this.constantWidth;
    }

    public void setConstantWidth(boolean constantWidth) {
        this.constantWidth = constantWidth;
    }

    @Override
    public void assignLineFormats(LineFormats other) {
        this.setLineColor(other.getLineColor());
        this.getLineWidth().assign(other.getLineWidth());
    }

    public void assignBranchFormats(BranchFormats other) {
        this.setConstantWidth(other.isConstantWidth());
        this.getMinSpaceAbove().assign(other.getMinSpaceAbove());
        this.getMinSpaceBelow().assign(other.getMinSpaceBelow());
        this.getMinLength().assign(other.getMinLength());
    }

    public void assign(BranchFormats other) {
        this.assignLineFormats(other);
        this.assignBranchFormats(other);
    }

    @Override
    public BranchFormats clone() {
        BranchFormats result = new BranchFormats();
        result.assign(this);
        return result;
    }
}

