/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.clipboard;

import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.clipboard.ClipboardContentType;
import info.bioinfweb.treegraph.document.clipboard.TreeClipboardException;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import java.util.Vector;

public class TreeClipboard {
    private Node subtreeRoot = null;
    private Legend[] subtreeLegends = null;
    private Vector<Label> labelList = new Vector();
    private Label label = null;
    private Legend legend = null;

    public void copySubtree(Tree tree, Node root) {
        this.clear();
        this.subtreeRoot = root.cloneWithSubtree(true);
        this.subtreeLegends = TreeSerializer.getLegendsInSubtree(tree, root);
        int i = 0;
        while (i < this.subtreeLegends.length) {
            this.subtreeLegends[i] = this.subtreeLegends[i].clone();
            ++i;
        }
    }

    public void copyLabel(Label label) {
        this.clear();
        this.label = label.clone();
    }

    private void copyLabelBlock(Labels labels, boolean above) {
        int lineNo = 0;
        while (lineNo < labels.lineCount(above)) {
            int lineIndex = 0;
            while (lineIndex < labels.labelCount(above, lineNo)) {
                this.labelList.add(labels.get(above, lineNo, lineIndex).clone());
                ++lineIndex;
            }
            ++lineNo;
        }
    }

    public void copyLabels(Labels labels) {
        this.clear();
        this.copyLabelBlock(labels, true);
        this.copyLabelBlock(labels, false);
    }

    public void copyLegend(Legend legend) {
        this.clear();
        this.legend = legend.clone();
    }

    public Label getLabel() {
        if (this.label != null) {
            return this.label.clone();
        }
        throw new TreeClipboardException("No label in clipboard");
    }

    public Label[] getLabelList() {
        if (!this.labelList.isEmpty()) {
            Label[] result = new Label[this.labelList.size()];
            int i = 0;
            while (i < this.labelList.size()) {
                result[i] = this.labelList.get(i).clone();
                ++i;
            }
            return result;
        }
        throw new TreeClipboardException("No label list in clipboard");
    }

    public Node getSubtree() {
        if (this.subtreeRoot != null) {
            return this.subtreeRoot.cloneWithSubtree(true);
        }
        throw new TreeClipboardException("No subtree in clipboard");
    }

    public Legend[] getSubtreeLegends() {
        if (this.subtreeRoot != null) {
            Legend[] result = new Legend[this.subtreeLegends.length];
            int i = 0;
            while (i < result.length) {
                result[i] = this.subtreeLegends[i].clone();
                ++i;
            }
            return result;
        }
        throw new TreeClipboardException("No subtree in clipboard");
    }

    public Legend getLegend() {
        if (this.legend != null) {
            return this.legend.clone();
        }
        throw new TreeClipboardException("No legend in clipboard");
    }

    public void clear() {
        this.subtreeRoot = null;
        this.subtreeLegends = null;
        this.labelList.clear();
        this.label = null;
        this.legend = null;
    }

    public boolean isEmpty() {
        return this.subtreeRoot == null && this.labelList.isEmpty() && this.label == null && this.legend == null;
    }

    public ClipboardContentType getContentType() {
        if (this.subtreeRoot != null) {
            return ClipboardContentType.SUBTREE;
        }
        if (this.label != null) {
            return ClipboardContentType.LABEL;
        }
        if (this.legend != null) {
            return ClipboardContentType.LEGEND;
        }
        if (!this.labelList.isEmpty()) {
            return ClipboardContentType.LABELS;
        }
        return ClipboardContentType.EMPTY;
    }
}

