/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.treegraph.document.Node;
import java.util.Vector;

public class TreePath {
    private Vector<Integer> path = new Vector();

    public TreePath(Node leaf) {
        this.setPath(leaf, null);
    }

    public TreePath(Node leaf, Node ancestor) {
        this.setPath(leaf, ancestor);
    }

    private void setPath(Node end, Node ancestor) {
        this.path.clear();
        while (end.getParent() != null && end != ancestor) {
            this.path.add(new Integer(end.getParent().getChildren().indexOf(end)));
            end = end.getParent();
        }
    }

    public Node findNode(Node root) {
        int i = this.path.size() - 1;
        while (i >= 0) {
            if (root.getChildren().size() <= this.path.get(i)) {
                return null;
            }
            root = root.getChildren().get(this.path.get(i));
            --i;
        }
        return root;
    }

    public int comparePosition(TreePath other) {
        int pos = 0;
        while (pos < this.path.size() && pos < other.path.size()) {
            if (this.path.get(pos) < other.path.get(pos)) {
                return 1;
            }
            if (this.path.get(pos) > other.path.get(pos)) {
                return -1;
            }
            ++pos;
        }
        return 0;
    }

    public int getPosition(int level) {
        return this.path.get(-(level - this.length() + 1));
    }

    public int length() {
        return this.path.size();
    }
}

