/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.commons.RandomValues;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Legends;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.ScaleBar;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.document.format.GlobalFormats;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.document.undo.CompareTextElementDataParameters;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

public class Tree {
    public static final float DEFAULT_LONGEST_PATH_LENGTH = 150.0f;
    public static final String UNIQUE_NAME_CHARS = "abcdefghijklmnopqrstuvwxyz01234567890";
    public static final int UNIQUE_NAME_LENGTH = 10;
    private Node paintStart = null;
    private ScaleBar scaleBar = new ScaleBar();
    private Legends legends = new Legends(this);
    private EnumMap<PositionPaintType, DistanceDimension> paintDimensions = new EnumMap(PositionPaintType.class);
    private GlobalFormats formats = new GlobalFormats();
    private TreeMap<String, Node> uniqueNameMap = new TreeMap();
    private HashSet<PaintableElement> elementSet = new HashSet();

    public Node getPaintStart() {
        return this.paintStart;
    }

    public void setPaintStart(Node paintStart) {
        this.paintStart = paintStart;
    }

    public ScaleBar getScaleBar() {
        return this.scaleBar;
    }

    public void setScaleBar(ScaleBar scaleBar) {
        this.scaleBar = scaleBar;
    }

    public Legends getLegends() {
        return this.legends;
    }

    public GlobalFormats getFormats() {
        return this.formats;
    }

    public boolean isEmpty() {
        return this.getPaintStart() == null;
    }

    public void clear() {
        this.setPaintStart(null);
        this.getLegends().clear();
    }

    public boolean contains(PaintableElement element) {
        return this.elementSet.contains(element);
    }

    public DistanceDimension getPaintDimension(PositionPaintType type) {
        DistanceDimension result = this.paintDimensions.get((Object)type);
        if (result == null) {
            result = new DistanceDimension();
            this.paintDimensions.put(type, result);
        }
        return result;
    }

    public String newUniqueName() {
        String result;
        while (this.getNodeByUniqueName(result = RandomValues.randChars(UNIQUE_NAME_CHARS, 10)) != null) {
        }
        return result;
    }

    private void assignUniqueNamesToSubtree(Node root) {
        if (!root.hasUniqueName()) {
            root.setUniqueName(this.newUniqueName());
        }
        this.uniqueNameMap.put(root.getUniqueName(), root);
        int i = 0;
        while (i < root.getChildren().size()) {
            this.assignUniqueNamesToSubtree(root.getChildren().get(i));
            ++i;
        }
    }

    public void assignUniqueNames() {
        this.uniqueNameMap.clear();
        if (this.getPaintStart() != null) {
            this.assignUniqueNamesToSubtree(this.getPaintStart());
        }
    }

    public void updateElementSet() {
        this.elementSet.clear();
        if (!this.isEmpty()) {
            PaintableElement[] elements = TreeSerializer.getElementsInSubtree((Node)this.getPaintStart(), (NodeType)NodeType.BOTH, PaintableElement.class);
            int i = 0;
            while (i < elements.length) {
                this.elementSet.add(elements[i]);
                ++i;
            }
        }
        int i = 0;
        while (i < this.getLegends().size()) {
            this.elementSet.add(this.legends.get(i));
            ++i;
        }
        this.elementSet.add(this.getScaleBar());
    }

    public Node getNodeByUniqueName(String uniqueName) {
        if (this.isEmpty() || uniqueName == null) {
            return null;
        }
        return this.uniqueNameMap.get(uniqueName);
    }

    public Node getFirstNodeByData(NodeBranchDataAdapter adapter, double value, boolean leavesOnly, CompareTextElementDataParameters parameters) {
        return this.getFirstNodeByData(adapter, new TextElementData(value), leavesOnly, parameters);
    }

    public Node getFirstNodeByData(NodeBranchDataAdapter adapter, String value, boolean leavesOnly, CompareTextElementDataParameters parameters) {
        return this.getFirstNodeByData(adapter, new TextElementData(value), leavesOnly, parameters);
    }

    public Node getFirstNodeByData(NodeBranchDataAdapter adapter, TextElementData data, boolean leavesOnly, CompareTextElementDataParameters parameters) {
        return Tree.getFirstNodeInSubtreeByData(this.getPaintStart(), adapter, data, leavesOnly, parameters);
    }

    public static Node getFirstNodeInSubtreeByData(Node root, NodeBranchDataAdapter adapter, TextElementData data, boolean leavesOnly, CompareTextElementDataParameters parameters) {
        TextElementData rootData = adapter.toTextElementData(root);
        if ((!leavesOnly || root.isLeaf()) && (data.equals(rootData) || parameters != null && parameters.createEditedValue(data.toString()).equals(parameters.createEditedValue(rootData.toString())))) {
            return root;
        }
        Iterator<Node> iterator = root.getChildren().iterator();
        while (iterator.hasNext()) {
            Node result = Tree.getFirstNodeInSubtreeByData(iterator.next(), adapter, data, leavesOnly, parameters);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Node getLinkedNode(PaintableElement element) {
        if (element instanceof Node) {
            return (Node)element;
        }
        if (element instanceof Branch) {
            return ((Branch)element).getTargetNode();
        }
        if (element instanceof Label) {
            return ((Label)element).getLabels().getHoldingBranch().getTargetNode();
        }
        return null;
    }

    public static Node mostRecentCommonAncestor(Node n1, Node n2) {
        Node ancestor = n1;
        while (ancestor != null) {
            if (n2 == ancestor || n2.isChildOf(ancestor)) {
                return ancestor;
            }
            ancestor = ancestor.getParent();
        }
        return null;
    }

    public static boolean hasAllBranchLengths(Node root, boolean needsRootLength) {
        if (root != null) {
            if (!(root.hasAfferentBranch() && root.getAfferentBranch().hasLength() || !needsRootLength)) {
                return false;
            }
            Iterator<Node> iterator = root.getChildren().iterator();
            while (iterator.hasNext()) {
                if (Tree.hasAllBranchLengths(iterator.next(), true)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasAllBranchLengths() {
        return Tree.hasAllBranchLengths(this.getPaintStart(), this.getFormats().getShowRooted());
    }

    public static double longestPath(Node root, boolean includeRootBranch) {
        if (Tree.hasAllBranchLengths(root, includeRootBranch)) {
            double result = 0.0;
            Iterator<Node> iterator = root.getChildren().iterator();
            while (iterator.hasNext()) {
                result = Math.max(result, Tree.longestPath(iterator.next(), true));
            }
            if (includeRootBranch) {
                result += root.getAfferentBranch().getLength();
            }
            return result;
        }
        return Double.NaN;
    }

    public double longestPath() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return Tree.longestPath(this.getPaintStart(), this.getFormats().getShowRooted());
    }

    public static boolean containsDecimal(NodeBranchDataAdapter adapter, Node root) {
        if (adapter.isDecimal(root)) {
            return true;
        }
        Iterator<Node> iterator = root.getChildren().iterator();
        while (iterator.hasNext()) {
            if (!Tree.containsDecimal(adapter, iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsDecimal(NodeBranchDataAdapter adapter) {
        if (this.isEmpty()) {
            return false;
        }
        return Tree.containsDecimal(adapter, this.getPaintStart());
    }
}

