/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.treegraph.document.TextElement;
import java.text.DecimalFormat;

public class TextElementData
implements Cloneable,
Comparable<TextElementData> {
    private String text = null;
    private double decimal = Double.NaN;

    public TextElementData() {
    }

    public TextElementData(String string) {
        this.setText(string);
    }

    public TextElementData(double decimal) {
        this.setDecimal(decimal);
    }

    public double getDecimal() {
        return this.decimal;
    }

    public void setDecimal(double doubleValue) {
        this.decimal = doubleValue;
        this.text = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String stringValue) {
        this.text = stringValue;
        this.decimal = Double.NaN;
    }

    public void clear() {
        this.text = null;
        this.decimal = Double.NaN;
    }

    public boolean isString() {
        return this.text != null;
    }

    public boolean isDecimal() {
        return !Double.isNaN(this.decimal);
    }

    public boolean isEmpty() {
        return !this.isDecimal() && !this.isString();
    }

    public String formatValue(DecimalFormat format) {
        if (this.isDecimal()) {
            return format.format(this.getDecimal());
        }
        if (this.isString()) {
            return this.getText();
        }
        return "";
    }

    public static String formatTextElement(TextElement element) {
        return element.getData().formatValue(element.getFormats().getDecimalFormat());
    }

    public String toString() {
        if (this.isDecimal()) {
            return "" + this.getDecimal();
        }
        if (this.isString()) {
            return this.getText();
        }
        return "";
    }

    public void assign(TextElementData other) {
        if (other.isDecimal()) {
            this.setDecimal(other.getDecimal());
        } else if (other.isString()) {
            this.setText(other.getText());
        } else {
            this.clear();
        }
    }

    public boolean equals(Object other) {
        if (other instanceof TextElementData) {
            TextElementData otherData = (TextElementData)other;
            if (this.isDecimal()) {
                return otherData.getDecimal() == this.getDecimal();
            }
            if (this.isString()) {
                return this.text.equals(otherData.getText());
            }
            return otherData.isEmpty();
        }
        return false;
    }

    public TextElementData clone() {
        TextElementData result = new TextElementData();
        result.assign(this);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.decimal);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public int compareTo(TextElementData other) {
        if (this.isDecimal()) {
            if (other.isDecimal()) {
                return Double.compare(this.getDecimal(), other.getDecimal());
            }
            return 1;
        }
        if (this.isString()) {
            if (other.isDecimal()) {
                return -1;
            }
            if (other.isString()) {
                return this.getText().compareTo(other.getText());
            }
            return 1;
        }
        if (other.isEmpty()) {
            return 0;
        }
        return -1;
    }
}

