/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.treegraph.document.format.PieChartLabelFormats;
import java.awt.Color;
import java.util.List;
import java.util.Vector;

public class PieColorManager {
    public static final Color[] DEFAULT_COLORS = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.ORANGE, Color.CYAN, Color.MAGENTA, Color.YELLOW, Color.PINK};
    private static PieColorManager firstInstance = null;
    private List<Color> colors = new Vector<Color>();

    private PieColorManager() {
        int i = 0;
        while (i < DEFAULT_COLORS.length) {
            this.colors.add(DEFAULT_COLORS[i]);
            ++i;
        }
    }

    public static PieColorManager getInstance() {
        if (firstInstance == null) {
            firstInstance = new PieColorManager();
        }
        return firstInstance;
    }

    public Color colorForIndex(int index) {
        Color result;
        block4: {
            result = this.colors.get(index % this.colors.size());
            int div = index / this.colors.size();
            if (div <= 0) break block4;
            if (div % 2 == 0) {
                int i = 0;
                while (i < div / 2) {
                    result = result.darker();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < div / 2 + 1) {
                    result = result.brighter();
                    ++i;
                }
            }
        }
        return result;
    }

    public void addDefaultColors(PieChartLabelFormats formats, int newSize) {
        while (formats.pieColorCount() < newSize) {
            formats.addPieColor(this.colorForIndex(formats.pieColorCount()));
        }
    }
}

