/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.treegraph.document.GraphicalLabel;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.LineElement;
import info.bioinfweb.treegraph.document.NoLinkedNodeException;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElement;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.format.ElementFormats;
import info.bioinfweb.treegraph.document.format.PieChartLabelFormats;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import info.bioinfweb.treegraph.graphics.positionpaint.positiondata.PieChartLabelPositionData;
import java.util.ArrayList;
import java.util.List;

public class PieChartLabel
extends GraphicalLabel
implements LineElement,
TextElement {
    private List<SectionData> sectionDataList = new ArrayList<SectionData>();
    private TextElementData title = new TextElementData();
    private PieChartLabelFormats formats = new PieChartLabelFormats(this);

    public PieChartLabel(Labels labels) {
        super(labels);
    }

    public List<SectionData> getSectionDataList() {
        return this.sectionDataList;
    }

    public double getValue(int index) {
        Node node = this.getLinkedNode();
        if (node == null) {
            throw new NoLinkedNodeException();
        }
        TextElementData data = IDManager.getDataByID(node, this.getSectionDataList().get(index).getValueColumnID());
        if (data != null) {
            return data.getDecimal();
        }
        return Double.NaN;
    }

    public String getCaptionText(int index) {
        String result = this.getFormats().getCaptionsContentType().containsCaptions() ? this.getSectionDataList().get(index).getCaption() : "";
        if (this.getFormats().getCaptionsContentType().containsValues()) {
            String value = this.getFormats().getCaptionsTextFormats().getDecimalFormat().format(this.getValue(index));
            if (!result.isEmpty()) {
                value = " (" + value + ")";
            }
            result = String.valueOf(result) + value;
        }
        return result;
    }

    public double[] getPieChartAngles() {
        double[] result = new double[this.getSectionDataList().size()];
        double sum = 0.0;
        int i = 0;
        while (i < result.length) {
            result[i] = this.getValue(i);
            sum += result[i];
            ++i;
        }
        i = 0;
        while (i < result.length) {
            result[i] = result[i] / sum * 360.0;
            ++i;
        }
        return result;
    }

    @Override
    public TextElementData getData() {
        return this.title;
    }

    @Override
    public void assignTextElementData(TextElement other) {
        this.getData().assign(other.getData());
    }

    @Override
    public PieChartLabelFormats getFormats() {
        return this.formats;
    }

    @Override
    public void setFormats(ElementFormats formats) {
        ((PieChartLabelFormats)formats).setOwner(this);
        this.formats = (PieChartLabelFormats)formats;
        this.reinsert();
    }

    @Override
    public PieChartLabelPositionData getPosition(PositionPaintType type) {
        PieChartLabelPositionData result = (PieChartLabelPositionData)this.positions.get((Object)type);
        if (result == null) {
            result = new PieChartLabelPositionData();
            this.positions.put(type, result);
        }
        return result;
    }

    public void assignPieChartData(PieChartLabel other) {
        this.getSectionDataList().clear();
        for (SectionData sectionData : other.getSectionDataList()) {
            this.getSectionDataList().add(sectionData.clone());
        }
    }

    @Override
    public PieChartLabel clone() {
        PieChartLabel result = new PieChartLabel(null);
        result.assignLabelData(this);
        result.assignTextElementData(this);
        result.assignPieChartData(this);
        result.setFormats(this.getFormats().clone());
        return result;
    }

    public static class SectionData
    implements Cloneable {
        private String valueColumnID = "";
        private String caption = "";

        public SectionData(String valueColumnID, String caption) {
            this.valueColumnID = valueColumnID;
            this.caption = caption;
        }

        public String getValueColumnID() {
            return this.valueColumnID;
        }

        public void setValueColumnID(String valueColumnID) {
            this.valueColumnID = valueColumnID;
        }

        public String getCaption() {
            return this.caption;
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }

        public String toString() {
            String caption = "";
            if (this.getCaption() != null && !this.getCaption().isEmpty()) {
                caption = " (" + this.getCaption() + ")";
            }
            return String.valueOf(this.getValueColumnID()) + caption;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.caption == null ? 0 : this.caption.hashCode());
            result = 31 * result + (this.valueColumnID == null ? 0 : this.valueColumnID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SectionData other = (SectionData)obj;
            if (this.caption == null ? other.caption != null : !this.caption.equals(other.caption)) {
                return false;
            }
            return !(this.valueColumnID == null ? other.valueColumnID != null : !this.valueColumnID.equals(other.valueColumnID));
        }

        public SectionData clone() {
            return new SectionData(this.getValueColumnID(), this.getCaption());
        }
    }
}

