/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.treegraph.document.Node;
import java.util.Vector;

public class NodeLadderizeComparable
implements Comparable<NodeLadderizeComparable> {
    public static final String CHILD_COUNT_KEY = "ladderizeChildCount";
    private Node node = null;
    private boolean ladderizeDown = true;

    public NodeLadderizeComparable(Node node, boolean ladderizeDown) {
        this.node = node;
        this.ladderizeDown = ladderizeDown;
    }

    public boolean isLadderizeDown() {
        return this.ladderizeDown;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public int compareTo(NodeLadderizeComparable other) {
        int result = (Integer)this.node.getAttributeMap().get(CHILD_COUNT_KEY) - (Integer)other.getNode().getAttributeMap().get(CHILD_COUNT_KEY);
        if (!this.ladderizeDown) {
            result *= -1;
        }
        return result;
    }

    public static NodeLadderizeComparable[] incloseSubnodes(Node root, boolean ladderizeDown) {
        Vector<NodeLadderizeComparable> list = new Vector<NodeLadderizeComparable>();
        int i = 0;
        while (i < root.getChildren().size()) {
            list.add(new NodeLadderizeComparable(root.getChildren().get(i), ladderizeDown));
            ++i;
        }
        return list.toArray(new NodeLadderizeComparable[list.size()]);
    }

    public static void addToNode(NodeLadderizeComparable[] elements, Node root) {
        int i = 0;
        while (i < elements.length) {
            root.getChildren().add(elements[i].getNode());
            ++i;
        }
    }

    public static int countNodes(Node root) {
        int result = 0;
        int i = 0;
        while (i < root.getChildren().size()) {
            result += NodeLadderizeComparable.countNodes(root.getChildren().get(i));
            ++i;
        }
        root.getAttributeMap().put(CHILD_COUNT_KEY, new Integer(result += root.getChildren().size()));
        return result;
    }
}

