/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.AbstractTextElement;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.CornerRadiusElement;
import info.bioinfweb.treegraph.document.HiddenDataElement;
import info.bioinfweb.treegraph.document.HiddenDataMap;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.LineElement;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.TreeElement;
import info.bioinfweb.treegraph.document.format.ElementFormats;
import info.bioinfweb.treegraph.document.format.LegendFormats;
import info.bioinfweb.treegraph.document.format.NodeFormats;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import info.bioinfweb.treegraph.graphics.positionpaint.positiondata.NodePositionData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class Node
extends AbstractTextElement
implements LineElement,
CornerRadiusElement,
HiddenDataElement,
TreeElement,
Cloneable {
    private Node parent = null;
    private ArrayList<Node> children = new ArrayList();
    private Branch afferentBranch = null;
    private NodeFormats formats = new NodeFormats();
    private String uniqueName = null;
    private HiddenDataMap hiddenDataMap = new HiddenDataMap(this);
    private HashMap<String, Object> attributeMap = new HashMap();

    public static Node newInstanceWithBranch() {
        Node result = new Node();
        result.setAfferentBranch(new Branch(result));
        return result;
    }

    @Override
    public NodePositionData getPosition(PositionPaintType type) {
        NodePositionData result = (NodePositionData)this.positions.get((Object)type);
        if (result == null) {
            result = new NodePositionData();
            this.positions.put(type, result);
        }
        return result;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public Branch getAfferentBranch() {
        return this.afferentBranch;
    }

    public void setAfferentBranch(Branch afferentBranch) {
        this.afferentBranch = afferentBranch;
        afferentBranch.setTargetNode(this);
    }

    public HashMap<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public boolean isLeaf() {
        return this.getChildren().size() == 0;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public boolean hasAfferentBranch() {
        return this.getAfferentBranch() != null;
    }

    public boolean isOnlySubelement() {
        if (!this.hasParent()) {
            return true;
        }
        return this.getParent().getChildren().size() == 1;
    }

    public boolean isFirst() {
        if (!this.hasParent()) {
            return true;
        }
        return this.getParent().getChildren().indexOf(this) == 0;
    }

    public boolean isLast() {
        if (!this.hasParent()) {
            return true;
        }
        return this.getParent().getChildren().indexOf(this) == this.getParent().getChildren().size() - 1;
    }

    public Node getPrevious() {
        if (this.hasParent() && !this.isFirst()) {
            return this.getParent().getChildren().get(this.getParent().getChildren().indexOf(this) - 1);
        }
        return null;
    }

    public Node getNext() {
        if (this.hasParent() && !this.isLast()) {
            return this.getParent().getChildren().get(this.getParent().getChildren().indexOf(this) + 1);
        }
        return null;
    }

    public Node getPreviousLeaf() {
        Node next = this;
        while (next != null && next.isFirst()) {
            next = next.getParent();
        }
        if (next != null) {
            return next.getPrevious().getLowestChild();
        }
        return null;
    }

    public Node getNextLeaf() {
        Node previous = this;
        while (previous != null && previous.isLast()) {
            previous = previous.getParent();
        }
        if (previous != null) {
            return previous.getNext().getHighestChild();
        }
        return null;
    }

    public boolean isChildOf(Node ancestor) {
        Node pos = this.getParent();
        while (pos != null) {
            if (pos == ancestor) {
                return true;
            }
            pos = pos.getParent();
        }
        return false;
    }

    public boolean containedInSubtree(AbstractPaintableElement element) {
        if (element == null) {
            return false;
        }
        if (element == this) {
            return true;
        }
        if (this.hasAfferentBranch()) {
            if (element == this.getAfferentBranch()) {
                return true;
            }
            if (element instanceof Label && this.getAfferentBranch().getLabels().contains((Label)element)) {
                return true;
            }
        }
        if (element instanceof Legend) {
            LegendFormats f = ((Legend)element).getFormats();
            return this.containedInSubtree(f.getAnchor(0)) && (f.hasOneAnchor() || this.containedInSubtree(f.getAnchor(1)));
        }
        int i = 0;
        while (i < this.getChildren().size()) {
            if (this.getChildren().get(i).containedInSubtree(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public NodeFormats getFormats() {
        return this.formats;
    }

    @Override
    public void setFormats(ElementFormats formats) {
        this.formats = (NodeFormats)formats;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        if (uniqueName != null) {
            uniqueName = uniqueName.toLowerCase();
        }
        this.uniqueName = uniqueName;
    }

    public boolean hasUniqueName() {
        return this.uniqueName != null;
    }

    @Override
    public HiddenDataMap getHiddenDataMap() {
        return this.hiddenDataMap;
    }

    public Node getHighestChild() {
        if (this.isLeaf()) {
            return this;
        }
        return this.getChildren().get(0).getHighestChild();
    }

    public Node getLowestChild() {
        if (this.isLeaf()) {
            return this;
        }
        return this.getChildren().get(this.getChildren().size() - 1).getLowestChild();
    }

    private void searchLeafNames(Node root, Vector<String> names) {
        if (root.isLeaf()) {
            names.add(TextElementData.formatTextElement(root));
        } else {
            int i = 0;
            while (i < root.getChildren().size()) {
                this.searchLeafNames(root.getChildren().get(i), names);
                ++i;
            }
        }
    }

    public Vector<String> leafNames() {
        Vector<String> result = new Vector<String>();
        this.searchLeafNames(this, result);
        return result;
    }

    @Override
    public Node getLinkedNode() {
        return this;
    }

    @Override
    public Node clone() {
        Node result = new Node();
        result.assignTextElementData(this);
        result.setAfferentBranch(this.getAfferentBranch().clone());
        result.getHiddenDataMap().assign(this.getHiddenDataMap());
        result.setFormats(this.getFormats().clone());
        result.attributeMap = new HashMap();
        return result;
    }

    public Node clone(boolean keepUniqheNames) {
        Node result = this.clone();
        if (keepUniqheNames) {
            result.setUniqueName(this.getUniqueName());
        }
        return result;
    }

    public Node cloneWithSubtree(boolean keepUniqueNames) {
        Node result = this.clone(keepUniqueNames);
        int i = 0;
        while (i < this.getChildren().size()) {
            Node child = this.getChildren().get(i).cloneWithSubtree(keepUniqueNames);
            child.setParent(result);
            result.getChildren().add(child);
            ++i;
        }
        return result;
    }

    @Override
    public String toString() {
        String result = super.toString();
        return String.valueOf(result.substring(0, result.length() - 1)) + ", uniqueName=" + this.getUniqueName() + "]";
    }
}

