/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.IconLabel;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.LabelLine;
import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.format.LabelFormats;
import info.bioinfweb.treegraph.document.tools.IDManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class Labels
implements Cloneable {
    private static final int INITIAL_CAPACITY = 2;
    private static final int CAPACITY_INCREMENT = 2;
    public static final double DEFAULT_LINE_INDEX_INCREMENT = 10.0;
    private Branch holdingBranch = null;
    private List<LabelLine> labelLinesAbove = new Vector<LabelLine>(2, 2);
    private List<LabelLine> labelLinesBelow = new Vector<LabelLine>(2, 2);

    public Labels(Branch holdingBranch) {
        this.holdingBranch = holdingBranch;
    }

    public Branch getHoldingBranch() {
        return this.holdingBranch;
    }

    public void setHoldingBranch(Branch holdingBranch) {
        this.holdingBranch = holdingBranch;
    }

    private void reduceLabelLineVectors() {
        int pos = this.labelLinesAbove.size() - 1;
        while (pos >= 0 && this.labelLinesAbove.get(pos).size() == 0) {
            this.labelLinesAbove.remove(pos);
            --pos;
        }
        pos = this.labelLinesBelow.size() - 1;
        while (pos >= 0 && this.labelLinesBelow.get(pos).size() == 0) {
            this.labelLinesBelow.remove(pos);
            --pos;
        }
    }

    private List<LabelLine> getLines(boolean above) {
        if (above) {
            return this.labelLinesAbove;
        }
        return this.labelLinesBelow;
    }

    private void calculateNewLinePosition(Label label, LabelLine line) {
        double leftLinePos;
        double newLinePos = label.getFormats().getLinePosition();
        int leftIndex = line.getIndexBeforeLinePos(newLinePos);
        if (leftIndex != -1 && newLinePos == (leftLinePos = line.get(leftIndex).getFormats().getLinePosition())) {
            if (line.size() - 1 != leftIndex) {
                label.getFormats().setLinePosition((leftLinePos + line.get(leftIndex + 1).getFormats().getLinePosition()) / 2.0);
            } else {
                label.getFormats().setLinePosition(newLinePos + 10.0);
            }
        }
    }

    public Object add(Label label) {
        Object result = null;
        if (this.getHoldingBranch() != null) {
            result = IDManager.removeElementWithID(this.getHoldingBranch().getTargetNode(), label.getID());
        }
        label.setLabels(this);
        LabelFormats f = label.getFormats();
        List<LabelLine> lines = this.getLines(f.isAbove());
        if (f.getLineNumber() >= lines.size()) {
            int i = lines.size();
            while (i <= f.getLineNumber()) {
                lines.add(new LabelLine());
                ++i;
            }
        }
        LabelLine line = lines.get(f.getLineNumber());
        this.calculateNewLinePosition(label, line);
        line.insert(label);
        return result;
    }

    public boolean remove(Label label) {
        int i = 0;
        while (i < this.lineCount(true)) {
            if (this.labelLinesAbove.get(i).remove(label)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.lineCount(false)) {
            if (this.labelLinesBelow.get(i).remove(label)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean remove(String id) {
        Label l = this.get(id);
        if (l != null) {
            return this.remove(l);
        }
        return false;
    }

    public boolean reinsert(Label label) {
        boolean result = this.remove(label);
        if (result) {
            this.add(label);
            this.reduceLabelLineVectors();
        }
        return result;
    }

    public Label get(boolean above, int lineNo, int lineIndex) {
        return this.getLines(above).get(lineNo).get(lineIndex);
    }

    private Label getNext(List<LabelLine> lines, int addend, int lineNo, int lineIndex) {
        int aboveLineNo = lineNo + addend;
        while (Math2.isBetween(aboveLineNo, 0, lines.size() - 1) && lines.get(aboveLineNo).size() == 0) {
            aboveLineNo += addend;
        }
        if (Math2.isBetween(aboveLineNo, 0, lines.size() - 1)) {
            LabelLine line = lines.get(aboveLineNo);
            return line.get(Math.min(lineIndex, line.size() - 1));
        }
        return null;
    }

    public Label getAbove(boolean above, int lineNo, int lineIndex) {
        this.reduceLabelLineVectors();
        List<LabelLine> lines = this.getLines(above);
        int addend = -1;
        if (above) {
            addend = 1;
        }
        return this.getNext(lines, addend, lineNo, lineIndex);
    }

    public Label getBelow(boolean above, int lineNo, int lineIndex) {
        this.reduceLabelLineVectors();
        List<LabelLine> lines = this.getLines(above);
        int addend = 1;
        if (above) {
            addend = -1;
        }
        return this.getNext(lines, addend, lineNo, lineIndex);
    }

    private Label searchByID(String id, boolean above) {
        int lineNo = 0;
        while (lineNo < this.lineCount(above)) {
            int lineIndex = 0;
            while (lineIndex < this.labelCount(above, lineNo)) {
                Label label = this.get(above, lineNo, lineIndex);
                if (label.getID().equals(id)) {
                    return label;
                }
                ++lineIndex;
            }
            ++lineNo;
        }
        return null;
    }

    public Label get(String id) {
        Label result = this.searchByID(id, true);
        if (result != null) {
            return result;
        }
        return this.searchByID(id, false);
    }

    public boolean contains(boolean above, Label label) {
        List<LabelLine> lines = this.getLines(above);
        int i = 0;
        while (i < lines.size()) {
            if (lines.get(i).contains(label)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(Label label) {
        if (this.contains(true, label)) {
            return true;
        }
        return this.contains(false, label);
    }

    private boolean contains(boolean above, Class<? extends Label> labelClass) {
        List<LabelLine> lines = this.getLines(above);
        for (LabelLine line : lines) {
            if (!line.contains(labelClass)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Class<? extends Label> labelClass) {
        if (this.contains(true, labelClass)) {
            return true;
        }
        return this.contains(false, labelClass);
    }

    public double getLastLinePos(boolean above, int lineNumber) {
        int labelCount = this.labelCount(above, lineNumber);
        if (labelCount > 0) {
            return this.get(above, lineNumber, labelCount - 1).getFormats().getLinePosition() + 10.0;
        }
        return 0.0;
    }

    public int getLineNo(boolean above, Label label) {
        List<LabelLine> lines = this.getLines(above);
        int i = 0;
        while (i < lines.size()) {
            if (lines.get(i).contains(label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLineIndex(Label label) {
        int result = this.getLineIndex(true, label);
        if (result == -1) {
            result = this.getLineIndex(false, label);
        }
        return result;
    }

    public int getLineIndex(boolean above, Label label) {
        return this.getLineIndex(above, this.getLineNo(above, label), label);
    }

    public int getLineIndex(boolean above, int lineNo, Label label) {
        return this.getLines(above).get(lineNo).indexOf(label);
    }

    public void clear() {
        this.labelLinesAbove.clear();
        this.labelLinesBelow.clear();
    }

    public boolean isEmpty() {
        this.reduceLabelLineVectors();
        return this.labelLinesAbove.isEmpty() && this.labelLinesBelow.isEmpty();
    }

    public int lineCount(boolean above) {
        if (above) {
            return this.labelLinesAbove.size();
        }
        return this.labelLinesBelow.size();
    }

    public int labelCount(boolean above, int lineNo) {
        if (above) {
            if (this.labelLinesAbove.size() <= lineNo) {
                return 0;
            }
            return this.labelLinesAbove.get(lineNo).size();
        }
        if (this.labelLinesBelow.size() <= lineNo) {
            return 0;
        }
        return this.labelLinesBelow.get(lineNo).size();
    }

    private boolean containsSameID(Labels other, boolean above) {
        int lineNo = 0;
        while (lineNo < this.lineCount(above)) {
            int linePos = 0;
            while (linePos < this.labelCount(above, lineNo)) {
                if (other.get(this.get(above, lineNo, linePos).getID()) != null) {
                    return true;
                }
                ++linePos;
            }
            ++lineNo;
        }
        return false;
    }

    public boolean containsSameID(Labels other) {
        return this.containsSameID(other, true) || this.containsSameID(other, false);
    }

    private void addLabelBlock(List<Label> list, boolean above, boolean textLabel, boolean iconLabel, boolean pieChart) {
        int lineNo = 0;
        while (lineNo < this.lineCount(above)) {
            int linePos = 0;
            while (linePos < this.labelCount(above, lineNo)) {
                Label l = this.get(above, lineNo, linePos);
                if (textLabel && l instanceof TextLabel || iconLabel && l instanceof IconLabel || pieChart && l instanceof PieChartLabel) {
                    list.add(l);
                }
                ++linePos;
            }
            ++lineNo;
        }
    }

    private List<Label> labelList(boolean textLabel, boolean iconLabel, boolean pieChart) {
        LinkedList<Label> result = new LinkedList<Label>();
        this.addLabelBlock(result, true, textLabel, iconLabel, pieChart);
        this.addLabelBlock(result, false, textLabel, iconLabel, pieChart);
        return result;
    }

    public Label[] toLabelArray(boolean textLabel, boolean iconLabel, boolean pieChart) {
        List<Label> list = this.labelList(textLabel, iconLabel, pieChart);
        return list.toArray(new Label[list.size()]);
    }

    public Label[] toLabelArray() {
        return this.toLabelArray(true, true, true);
    }

    public TextLabel[] toTextLabelArray() {
        List<Label> list = this.labelList(true, false, false);
        return list.toArray(new TextLabel[list.size()]);
    }

    public IconLabel[] toIconLabelArray() {
        List<Label> list = this.labelList(false, true, false);
        return list.toArray(new IconLabel[list.size()]);
    }

    public PieChartLabel[] toPieChartLabelArray() {
        List<Label> list = this.labelList(false, false, true);
        return list.toArray(new PieChartLabel[list.size()]);
    }

    private void cloneLabelBlock(boolean above, Labels target) {
        int lineNo = 0;
        while (lineNo < this.lineCount(above)) {
            int lineIndex = 0;
            while (lineIndex < this.labelCount(above, lineNo)) {
                Label label = this.get(above, lineNo, lineIndex);
                label = label.clone();
                target.add(label);
                ++lineIndex;
            }
            ++lineNo;
        }
    }

    public Labels clone() {
        Labels result = new Labels(null);
        this.cloneLabelBlock(true, result);
        this.cloneLabelBlock(false, result);
        return result;
    }
}

