/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.treegraph.document.Label;
import java.util.Vector;

public class LabelLine
implements Cloneable {
    private static final int INITIAL_CAPACITY = 4;
    private static final int CAPACITY_INCREMENT = 4;
    private Vector<Label> line = new Vector(4, 4);

    public int insert(Label label) {
        int pos = 0;
        while (pos < this.line.size() && this.line.get(pos).getFormats().getLinePosition() <= label.getFormats().getLinePosition()) {
            ++pos;
        }
        this.line.insertElementAt(label, pos);
        return pos;
    }

    public boolean remove(Label label) {
        return this.line.remove(label);
    }

    public Label get(int pos) {
        return this.line.get(pos);
    }

    public int getIndexBeforeLinePos(double linePos) {
        int pos = 0;
        while (pos < this.line.size() && linePos >= this.get(pos).getFormats().getLinePosition()) {
            ++pos;
        }
        return pos - 1;
    }

    public boolean contains(Label label) {
        return this.line.contains(label);
    }

    public boolean contains(Class<? extends Label> labelClass) {
        for (Label label : this.line) {
            if (!labelClass.isInstance(label)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.line.size();
    }

    protected LabelLine clone() {
        LabelLine result = new LabelLine();
        int i = 0;
        while (i < this.size()) {
            result.insert(this.get(i).clone());
            ++i;
        }
        return result;
    }

    public int indexOf(Label label) {
        return this.line.indexOf(label);
    }
}

