/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TreeElement;
import info.bioinfweb.treegraph.document.format.LabelFormats;
import java.util.regex.Pattern;

public abstract class Label
extends AbstractPaintableElement
implements TreeElement,
Cloneable {
    private static final Pattern idPattern = Pattern.compile("[_\\w]+");
    private Labels labels = null;
    private String id = "";

    private Label() {
    }

    public Label(Labels labels) {
        this.labels = labels;
    }

    @Override
    public abstract LabelFormats getFormats();

    public String getID() {
        return this.id;
    }

    public Labels getLabels() {
        return this.labels;
    }

    public Branch getHoldingBranch() {
        if (this.getLabels() != null) {
            return this.getLabels().getHoldingBranch();
        }
        return null;
    }

    public void setLabels(Labels labels) {
        this.labels = labels;
    }

    public void setID(String id) {
        this.id = id;
    }

    public static boolean idIsValid(String id) {
        if (id == null) {
            return false;
        }
        return idPattern.matcher(id).matches();
    }

    public void reinsert() {
        if (this.getLabels() != null) {
            this.getLabels().reinsert(this);
        }
    }

    public void assignLabelData(Label other) {
        this.setID(other.getID());
    }

    public boolean isAbove() {
        return this.getLabels() != null && this.getLabels().contains(true, this);
    }

    public int getLineNo() {
        if (this.getLabels() != null) {
            boolean above = this.getLabels().contains(true, this);
            return this.getLabels().getLineNo(above, this);
        }
        return -1;
    }

    public int getLineIndex() {
        if (this.getLabels() != null) {
            boolean above = this.getLabels().contains(true, this);
            return this.getLabels().getLineIndex(above, this);
        }
        return -1;
    }

    public Label getNext() {
        if (this.getLabels() != null) {
            boolean above = this.getLabels().contains(true, this);
            int lineNo = this.getLabels().getLineNo(above, this);
            int lineIndex = this.getLabels().getLineIndex(above, lineNo, this);
            if (lineIndex < this.getLabels().labelCount(above, lineNo) - 1) {
                return this.getLabels().get(above, lineNo, lineIndex + 1);
            }
        }
        return null;
    }

    public Label getPrevious() {
        if (this.getLabels() != null) {
            boolean above = this.getLabels().contains(true, this);
            int lineNo = this.getLabels().getLineNo(above, this);
            int lineIndex = this.getLabels().getLineIndex(above, lineNo, this);
            if (lineIndex > 0) {
                return this.getLabels().get(above, lineNo, lineIndex - 1);
            }
        }
        return null;
    }

    public Label getAbove() {
        if (this.getLabels() != null) {
            return this.getLabels().getAbove(this.isAbove(), this.getLineNo(), this.getLineIndex());
        }
        return null;
    }

    public Label getBelow() {
        if (this.getLabels() != null) {
            return this.getLabels().getBelow(this.isAbove(), this.getLineNo(), this.getLineIndex());
        }
        return null;
    }

    @Override
    public Node getLinkedNode() {
        return this.getLabels().getHoldingBranch().getTargetNode();
    }

    @Override
    public abstract Label clone();
}

