/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElement;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.tools.IDManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HiddenDataMap
implements Map<String, TextElementData> {
    private HashMap<String, TextElementData> map = new HashMap();
    private Node owner = null;

    public HiddenDataMap(Node owner) {
        this.owner = owner;
    }

    public Node getOwner() {
        return this.owner;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Object putForID(String id, TextElementData value) {
        Object result = null;
        if (this.getOwner() != null) {
            result = IDManager.removeElementWithID(this.getOwner(), id);
        }
        this.map.put(id, value);
        return result;
    }

    @Override
    public TextElementData put(String id, TextElementData value) {
        Object result = this.putForID(id, value);
        if (result instanceof TextElementData) {
            return (TextElementData)result;
        }
        if (result instanceof TextElement) {
            return ((TextElement)result).getData();
        }
        return null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<TextElementData> values() {
        return this.map.values();
    }

    public Iterator<String> idIterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, TextElementData>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object other) {
        return this.map.equals(other);
    }

    @Override
    public TextElementData get(Object key) {
        return this.map.get(key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public void putAll(Map<? extends String, ? extends TextElementData> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public TextElementData remove(Object key) {
        return this.map.remove(key);
    }

    public String toString() {
        return this.map.toString();
    }

    public boolean containsSameID(HiddenDataMap other) {
        Iterator<String> iterator = this.idIterator();
        while (iterator.hasNext()) {
            if (!other.containsKey(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public void assign(HiddenDataMap other) {
        this.clear();
        Iterator<String> iterator = other.idIterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            this.put(id, other.get(id).clone());
        }
    }
}

