/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.commons.changemonitor.ChangeMonitorable;
import info.bioinfweb.commons.io.DefaultNameManager;
import info.bioinfweb.commons.io.FormatVersion;
import info.bioinfweb.commons.io.Savable;
import info.bioinfweb.commons.swing.AccessibleUndoManager;
import info.bioinfweb.commons.swing.SwingSavable;
import info.bioinfweb.commons.swing.SwingSaver;
import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.change.DocumentChangeEvent;
import info.bioinfweb.treegraph.document.change.DocumentListener;
import info.bioinfweb.treegraph.document.io.ReadWriteFactory;
import info.bioinfweb.treegraph.document.io.ReadWriteFormat;
import info.bioinfweb.treegraph.document.io.xtg.XTGFilter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.VoidNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import info.bioinfweb.treegraph.gui.CurrentDirectoryModel;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import java.io.File;
import java.util.EnumMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;

public class Document
extends SwingSaver
implements ChangeMonitorable,
Savable,
SwingSavable {
    private static final int VIEWS_CAPACITY = 4;
    private static final int VIEWS_CAPACITY_INCREMENT = 4;
    private FormatVersion version = null;
    private AccessibleUndoManager undoManager = new AccessibleUndoManager();
    private TreeInternalFrame frame = null;
    private Vector<DocumentListener> views = new Vector(4, 4);
    private Tree tree = new Tree();
    private EnumMap<PositionPaintType, Boolean> positioners = new EnumMap(PositionPaintType.class);
    private EnumMap<PositionPaintType, Boolean> painters = new EnumMap(PositionPaintType.class);
    private NodeBranchDataAdapter defaultLeafAdapter = new NodeNameAdapter();
    private NodeBranchDataAdapter defaultSupportAdapter = new VoidNodeBranchDataAdapter("Not specified.");

    public Document() {
        this.init(true);
    }

    public Document(String name) {
        DefaultNameManager nameManager = Main.getInstance().getNameManager();
        this.setDefaultName(this.getDefaultName().replace(nameManager.getPrefix(), name));
        this.init(true);
    }

    public Document(boolean registerFileChooser) {
        this.init(registerFileChooser);
    }

    private void init(boolean registerFileChooser) {
        this.initSets();
        this.getFileChooser().addChoosableFileFilter(new XTGFilter());
        if (registerFileChooser) {
            CurrentDirectoryModel.getInstance().addFileChooser(this.getFileChooser());
        }
        this.setDefaultExtension(".xtg");
        this.addFileExtension(".xml");
        this.setDefaultName(Main.getInstance().getNameManager().newDefaultName());
    }

    private void initSets() {
        PositionPaintType type;
        PositionPaintType[] positionPaintTypeArray = PositionPaintType.values();
        int n = positionPaintTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            type = positionPaintTypeArray[n2];
            this.positioners.put(type, false);
            ++n2;
        }
        positionPaintTypeArray = PositionPaintType.values();
        n = positionPaintTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            type = positionPaintTypeArray[n2];
            this.painters.put(type, false);
            ++n2;
        }
    }

    public FormatVersion getVersion() {
        return this.version;
    }

    public void setVersion(FormatVersion version) {
        this.version = version;
    }

    public AccessibleUndoManager getUndoManager() {
        return this.undoManager;
    }

    public TreeInternalFrame getFrame() {
        return this.frame;
    }

    public void setFrame(TreeInternalFrame frame) {
        this.frame = frame;
        this.updateFrame();
    }

    public boolean addView(DocumentListener view) {
        if (!this.views.contains(view)) {
            return this.views.add(view);
        }
        return false;
    }

    public boolean removeView(DocumentListener view) {
        return this.views.remove(view);
    }

    public void registerPositioner(PositionPaintType type) {
        this.positioners.put(type, true);
    }

    public void unregisterPositioner(PositionPaintType type) {
        this.painters.put(type, true);
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
        this.registerChange();
    }

    private void updateFrame() {
        TreeInternalFrame frame = this.getFrame();
        if (frame != null) {
            String title = this.getDefaultNameOrPath();
            if (this.hasChanged()) {
                title = "*" + title;
            }
            frame.setTitle(title);
            frame.setScrollPaneBgColor(this.getTree().getFormats().getBackgroundColor());
        }
    }

    @Override
    public void setDefaultName(String name) {
        super.setDefaultName(name);
        this.updateFrame();
    }

    @Override
    public void setFile(File file) {
        super.setFile(file);
        this.updateFrame();
    }

    public NodeBranchDataAdapter getDefaultLeafAdapter() {
        return this.defaultLeafAdapter;
    }

    public void setDefaultLeafAdapter(NodeBranchDataAdapter defaultLeafAdapter) {
        this.defaultLeafAdapter = defaultLeafAdapter;
    }

    public NodeBranchDataAdapter getDefaultSupportAdapter() {
        return this.defaultSupportAdapter;
    }

    public void setDefaultSupportAdapter(NodeBranchDataAdapter defaultSupportAdapter) {
        this.defaultSupportAdapter = defaultSupportAdapter;
    }

    public void executeEdit(DocumentEdit edit) {
        if (!this.getUndoManager().addEdit((UndoableEdit)edit)) {
            throw new RuntimeException("The edit could not be executed.");
        }
        edit.redo();
    }

    private void alertPositioners() {
        PositionPaintType[] positionPaintTypeArray = PositionPaintType.values();
        int n = positionPaintTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PositionPaintType type = positionPaintTypeArray[n2];
            if (this.positioners.get((Object)type).booleanValue()) {
                PositionPaintFactory.getInstance().getPositioner(type).positionAll(this, 1.0f);
            }
            ++n2;
        }
    }

    private void fireChangeHappened(DocumentEdit edit) {
        DocumentChangeEvent event = new DocumentChangeEvent(this, edit);
        int i = 0;
        while (i < this.views.size()) {
            this.views.get(i).changeHappened(event);
            ++i;
        }
    }

    @Override
    public void registerChange() {
        this.registerChange(null);
    }

    public void registerChange(DocumentEdit edit) {
        super.registerChange();
        this.getTree().updateElementSet();
        this.alertPositioners();
        this.fireChangeHappened(edit);
        this.updateFrame();
    }

    @Override
    public void reset() {
        super.reset();
        this.updateFrame();
    }

    protected void saveDataToFile(File file) {
        try {
            ReadWriteFactory.getInstance().getWriter(ReadWriteFormat.XTG).write(this, file);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "The error \"" + e.getMessage() + "\" occured when writing to the file \"" + file.getAbsolutePath() + "\"", "Error", 0);
        }
    }

    public String toString() {
        return this.getDefaultNameOrPath();
    }
}

