/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.commons.graphics.GraphicsUtils;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.GraphicalLabel;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.format.FormatUtils;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import java.awt.Color;
import javax.swing.JOptionPane;

public class ContrastManager {
    private State state = State.UNDEFINED;

    private boolean confirmChange() {
        if (this.state.equals((Object)State.UNDEFINED)) {
            Object[] options = new String[]{"Change unsifficient contrasted colors", "Paste unchanged", "Cancel"};
            switch (JOptionPane.showOptionDialog(MainFrame.getInstance(), "One or more of the elements you are trying to paste have an unsufficient contrast to the background of the document.", "Unsufficient contrast", 2, 2, null, options, options[0])) {
                case 0: {
                    this.state = State.CHANGE;
                    break;
                }
                case 1: {
                    this.state = State.NO_CHANGE;
                    break;
                }
                default: {
                    this.state = State.ABORTED;
                }
            }
        }
        return !this.state.equals((Object)State.ABORTED);
    }

    private boolean checkColor(Color foreground, Color background) {
        return GraphicsUtils.brightnessDifference(foreground, background) < FormatUtils.MIN_COLOR_DIFFERENCE;
    }

    private boolean ensureLabelBlock(Labels labels, boolean above, Color bgColor, Color defaultColor) {
        int lineNo = 0;
        while (lineNo < labels.lineCount(above)) {
            int lineIndex = 0;
            while (lineIndex < labels.labelCount(above, lineNo)) {
                Label label = labels.get(above, lineNo, lineIndex);
                Color color = label instanceof TextLabel ? ((TextLabel)label).getFormats().getTextColor() : ((GraphicalLabel)label).getFormats().getLineColor();
                if (this.checkColor(color, bgColor)) {
                    if (this.confirmChange()) {
                        if (this.state.equals((Object)State.CHANGE)) {
                            if (label instanceof TextLabel) {
                                ((TextLabel)label).getFormats().setTextColor(defaultColor);
                            } else {
                                ((GraphicalLabel)label).getFormats().setLineColor(defaultColor);
                            }
                        }
                    } else {
                        return false;
                    }
                }
                ++lineIndex;
            }
            ++lineNo;
        }
        return true;
    }

    private boolean ensureSubtreeContrast(Document document, Node root) {
        Color bgColor = document.getTree().getFormats().getBackgroundColor();
        if (this.checkColor(root.getFormats().getTextColor(), bgColor) && this.confirmChange() && this.state.equals((Object)State.CHANGE)) {
            root.getFormats().setTextColor(FormatUtils.getTextColor(document));
        }
        if (this.checkColor(root.getFormats().getLineColor(), bgColor) && this.confirmChange() && this.state.equals((Object)State.CHANGE)) {
            root.getFormats().setLineColor(FormatUtils.getLineColor(document));
        }
        if (this.checkColor(root.getAfferentBranch().getFormats().getLineColor(), bgColor) && this.confirmChange() && this.state.equals((Object)State.CHANGE)) {
            root.getAfferentBranch().getFormats().setLineColor(FormatUtils.getLineColor(document));
        }
        if (!this.ensureLabelBlock(root.getAfferentBranch().getLabels(), true, bgColor, FormatUtils.getTextColor(document))) {
            return false;
        }
        if (!this.ensureLabelBlock(root.getAfferentBranch().getLabels(), false, bgColor, FormatUtils.getTextColor(document))) {
            return false;
        }
        if (this.state.equals((Object)State.CHANGE) || this.state.equals((Object)State.UNDEFINED)) {
            int i = 0;
            while (i < root.getChildren().size()) {
                if (!this.ensureSubtreeContrast(document, root.getChildren().get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return !this.state.equals((Object)State.ABORTED);
    }

    private boolean ensureLegendContrast(Document document, Legend legend) {
        Color bgColor = document.getTree().getFormats().getBackgroundColor();
        if (this.checkColor(legend.getFormats().getTextColor(), bgColor) && this.confirmChange() && this.state.equals((Object)State.CHANGE)) {
            legend.getFormats().setTextColor(FormatUtils.getTextColor(document));
        }
        if (this.checkColor(legend.getFormats().getLineColor(), bgColor) && this.confirmChange() && this.state.equals((Object)State.CHANGE)) {
            legend.getFormats().setLineColor(FormatUtils.getLineColor(document));
        }
        return !this.state.equals((Object)State.ABORTED);
    }

    public boolean ensureContrast(Document document, Node root, Legend[] legends) {
        this.state = State.UNDEFINED;
        boolean result = this.ensureSubtreeContrast(document, root);
        int pos = 0;
        while (pos < legends.length && (this.state.equals((Object)State.UNDEFINED) || this.state.equals((Object)State.CHANGE))) {
            result = result || this.ensureLegendContrast(document, legends[pos]);
            ++pos;
        }
        return result;
    }

    private boolean ensureLabelContrast(Document document, Label label) {
        Color color = label instanceof TextLabel ? ((TextLabel)label).getFormats().getTextColor() : ((GraphicalLabel)label).getFormats().getLineColor();
        if (this.checkColor(color, document.getTree().getFormats().getBackgroundColor()) && this.confirmChange() && this.state.equals((Object)State.CHANGE)) {
            if (label instanceof TextLabel) {
                ((TextLabel)label).getFormats().setTextColor(FormatUtils.getTextColor(document));
            } else {
                ((GraphicalLabel)label).getFormats().setLineColor(FormatUtils.getTextColor(document));
            }
        }
        return !this.state.equals((Object)State.ABORTED);
    }

    public boolean ensureContrast(Document document, Label label) {
        this.state = State.UNDEFINED;
        return this.ensureLabelContrast(document, label);
    }

    public boolean ensureContrast(Document document, Label[] labels) {
        this.state = State.UNDEFINED;
        int i = 0;
        while (i < labels.length) {
            if (!this.ensureLabelContrast(document, labels[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean ensureContrast(Document document, Legend legend) {
        this.state = State.UNDEFINED;
        return this.ensureLegendContrast(document, legend);
    }

    static enum State {
        UNDEFINED,
        CHANGE,
        NO_CHANGE,
        ABORTED;

    }
}

