/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document;

import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.HiddenDataElement;
import info.bioinfweb.treegraph.document.HiddenDataMap;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.LineElement;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TreeElement;
import info.bioinfweb.treegraph.document.format.BranchFormats;
import info.bioinfweb.treegraph.document.format.ElementFormats;
import info.bioinfweb.treegraph.document.format.LineFormats;

public class Branch
extends AbstractPaintableElement
implements LineElement,
HiddenDataElement,
TreeElement,
Cloneable {
    private double length = Double.NaN;
    private Labels labels = new Labels(this);
    private Node targetNode = null;
    private BranchFormats formats = new BranchFormats();
    private HiddenDataMap hiddenDataMap = null;

    public Branch(Node target) {
        this.targetNode = target;
        this.hiddenDataMap = new HiddenDataMap(this.getTargetNode());
    }

    public LineFormats getLineFormats() {
        return this.getFormats();
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public boolean hasLength() {
        return !Double.isNaN(this.getLength());
    }

    public void deleteLength() {
        this.setLength(Double.NaN);
    }

    public Labels getLabels() {
        return this.labels;
    }

    public Node getTargetNode() {
        return this.targetNode;
    }

    public void setTargetNode(Node targetNode) {
        this.targetNode = targetNode;
    }

    @Override
    public BranchFormats getFormats() {
        return this.formats;
    }

    @Override
    public void setFormats(ElementFormats formats) {
        this.formats = (BranchFormats)formats;
    }

    @Override
    public HiddenDataMap getHiddenDataMap() {
        return this.hiddenDataMap;
    }

    @Override
    public Node getLinkedNode() {
        return this.getTargetNode();
    }

    @Override
    public Branch clone() {
        Branch result = new Branch(null);
        result.setLength(this.getLength());
        result.labels = this.getLabels().clone();
        result.labels.setHoldingBranch(result);
        result.getHiddenDataMap().assign(this.getHiddenDataMap());
        result.setFormats(this.getFormats().clone());
        return result;
    }

    public String toString() {
        if (this.getLinkedNode() != null) {
            return "Branch on node " + this.getLinkedNode().getUniqueName();
        }
        return super.toString();
    }
}

