/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.cmd;

import info.bioinfweb.commons.CommandLineReader;
import info.bioinfweb.commons.collections.ParameterMap;
import info.bioinfweb.treegraph.cmd.CmdLoadLogger;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.document.io.ReadWriteFactory;
import info.bioinfweb.treegraph.document.io.ReadWriteFormat;
import info.bioinfweb.treegraph.document.io.ReadWriteParameterMap;
import info.bioinfweb.treegraph.graphics.export.GraphicFormat;
import info.bioinfweb.treegraph.graphics.export.GraphicWriterFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import info.bioinfweb.treegraph.gui.dialogs.ResolutionInput;
import java.io.File;

public class ImageGenerator {
    public static final String CLADOGRAM_OPTION = "-clad";
    public static final String PHYLOGRAM_OPTION = "-phyl";
    public static final String WIDTH_OPTION = "-width";
    public static final String HEIGHT_OPTION = "-height";
    public static final String RESOLUTION_OPTION = "-res";
    public static final String UNIT_PPM = "ppm";
    public static final String UNIT_PPI = "ppi";
    public static final String UNIT_MM = "mm";
    public static final String UNIT_PT = "pt";
    public static final String UNIT_PX = "px";

    private static float readRes(String content) {
        if (content.endsWith(UNIT_PPM)) {
            return Float.parseFloat(content.substring(0, content.length() - UNIT_PPM.length()));
        }
        if (content.endsWith(UNIT_PPI)) {
            return ResolutionInput.ppiToPPM(Float.parseFloat(content.substring(0, content.length() - UNIT_PPI.length())));
        }
        return Float.parseFloat(content);
    }

    private static float readDistance(String content, ParameterMap hints) {
        float value = content.endsWith(UNIT_PX) ? Float.parseFloat(content.substring(0, content.length() - UNIT_PX.length())) : (content.endsWith(UNIT_MM) ? Float.parseFloat(content.substring(0, content.length() - UNIT_MM.length())) : (content.endsWith(UNIT_PT) ? DistanceValue.pointsToMillimeters(Float.parseFloat(content.substring(0, content.length() - UNIT_PT.length()))) : Float.parseFloat(content)));
        hints.put("dimensionsInPixels", new Boolean(content.endsWith(UNIT_PX)));
        return value;
    }

    public static boolean generate(CommandLineReader reader) {
        ReadWriteFactory rwf = ReadWriteFactory.getInstance();
        GraphicWriterFactory gwf = GraphicWriterFactory.getInstance();
        GraphicFormat format = gwf.formatByFileName(reader.getArg(2));
        if (rwf.getFilter(ReadWriteFormat.XTG).validExtension(reader.getArg(1)) && format != null) {
            try {
                ReadWriteParameterMap parameterMap = new ReadWriteParameterMap();
                parameterMap.putApplicationLogger(CmdLoadLogger.getInstance());
                Document document = rwf.getReader(ReadWriteFormat.XTG).read(new File(reader.getArg(1)), parameterMap);
                PositionPaintType type = PositionPaintType.RECT_CLAD;
                if (reader.contained(PHYLOGRAM_OPTION, 3) != -1) {
                    type = PositionPaintType.PHYLOGRAM;
                }
                PositionPaintFactory.getInstance().getPositioner(type).positionAll(document, 1.0f);
                ParameterMap hints = new ParameterMap();
                float pixelsPerMillimeter = 2.8346457f;
                int pos = reader.contained(RESOLUTION_OPTION, 3);
                if (pos != -1) {
                    pixelsPerMillimeter = ImageGenerator.readRes(reader.getArg(pos + 1));
                }
                hints.put(UNIT_PPM, new Float(pixelsPerMillimeter));
                DistanceDimension d = document.getTree().getPaintDimension(type);
                float aspectRatio = d.getWidth().getInMillimeters() / d.getHeight().getInMillimeters();
                float width = d.getWidth().getInMillimeters();
                float height = d.getHeight().getInMillimeters();
                pos = reader.contained(WIDTH_OPTION, 3);
                if (pos != -1) {
                    width = ImageGenerator.readDistance(reader.getArg(pos + 1), hints);
                    height = width / aspectRatio;
                } else {
                    pos = reader.contained(HEIGHT_OPTION, 3);
                    if (pos != -1) {
                        height = ImageGenerator.readDistance(reader.getArg(pos + 1), hints);
                        width = height * aspectRatio;
                    } else {
                        hints.put("dimensionsInPixels", new Boolean(false));
                    }
                }
                hints.put("width", Float.valueOf(width));
                hints.put("height", Float.valueOf(height));
                gwf.getWriter(format).write(document, PositionPaintFactory.getInstance().getPainter(type), hints, new File(reader.getArg(2)));
                return true;
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid floating point parameter. (Either the number format or the unit is incorrect.)");
            }
            catch (OutOfMemoryError e) {
                System.out.println("There is not enough memory avialable.\nYou can try to run TreeGraph with the following command line options for the\n Java Virtual Machine from the TreeGraph installation directory:\n\"java -Xms32m -Xmx1024m -jar TreeGraph.jar [additional user defined parameters]\"");
            }
            catch (Exception e) {
                System.out.println("An error occured.");
            }
        } else {
            System.out.println("Invalid parameters. (Possibly an invalid file extension was used.)");
        }
        System.out.println("Conversion could not complete.");
        return false;
    }
}

