/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.cmd;

import info.bioinfweb.commons.CommandLineReader;
import info.bioinfweb.commons.Math2;
import info.bioinfweb.commons.appversion.ApplicationVersion;
import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.PreferencesConstants;
import info.bioinfweb.treegraph.cmd.CmdLoadLogger;
import info.bioinfweb.treegraph.cmd.ImageGenerator;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.io.DocumentReader;
import info.bioinfweb.treegraph.document.io.ReadWriteFactory;
import info.bioinfweb.treegraph.document.io.ReadWriteFormat;
import info.bioinfweb.treegraph.document.io.ReadWriteParameterMap;
import info.bioinfweb.treegraph.document.nodebranchdata.TextLabelAdapter;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.updatecenter.dataxchange.VersionListXMLReader;
import info.bioinfweb.updatecenter.dataxchange.beans.ListInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CmdProcessor
implements PreferencesConstants {
    public static final String VERSION_OPTION = "-version";
    public static final String CONVERT_OPTION = "-convert";
    public static final String XTG_OPTION = "-xtg";
    public static final String NEWICK_OPTION = "-newick";
    public static final String NEXUS_OPTION = "-nexus";
    public static final String IMAGE_OPTION = "-image";
    public static final String DEFAULT_LABEL_ID = "internals";
    private File initialFile = null;

    public File getInitialFile() {
        return this.initialFile;
    }

    private void checkUpdate() {
        String lastChecked;
        Preferences preferences = Main.getInstance().getPreferences();
        if (preferences.getBoolean("isFirstRun", true)) {
            preferences.putBoolean("doVersionCheck", JOptionPane.showOptionDialog(null, "You seem to using TreeGraph 2 for the first time on this system.\nBy default TreeGraph 2 will check is a newer version of the software is available on startup to inform you on possible updates.\n(You can edit your settings later by selecting \"Window\" -> \"Preferences\" from the main menu.)\n\nYou can read our privacy policy by selecting \"Help\" -> \"Privacy Policy\" from the main menu.\n\n", "Check for updates", 0, 3, null, new String[]{"Check for updates on start (recommended)", "Never check for updates"}, null) == 0);
            preferences.putBoolean("isFirstRun", false);
        }
        if (preferences.getBoolean("doVersionCheck", false) && ((lastChecked = preferences.get("lastVersionCheck", null)) == null || Math2.parseDouble(lastChecked) + 3600000.0 <= (double)System.currentTimeMillis())) {
            try {
                ListInfo list = new VersionListXMLReader().read(new URL("http://treegraph.bioinfweb.info/UpdateCenter/App/VersionList.jsp").openStream());
                ApplicationVersion remoteVersion = (ApplicationVersion)list.getEntries().get(0);
                if (Main.getInstance().getVersion().getBuildNumber() < remoteVersion.getBuildNumber()) {
                    if (JOptionPane.showConfirmDialog(null, "There is a newer version of TreeGraph 2 available for download.\n(You are using " + Main.getInstance().getVersion() + " and could update to " + remoteVersion + ".)\n\n" + "Do you want to go to the download page now?", "Newer version available", 0, 1) == 0) {
                        Main.getInstance().getWikiHelp().setPage("http://treegraph.bioinfweb.info/UpdateCenter/App/DownloadPage.jsp");
                    }
                    preferences.put("lastVersionCheck", "" + System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void startUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.checkUpdate();
        SwingUtilities.invokeLater(MainFrame.getInstance());
    }

    private void convert(CommandLineReader reader) {
        File source = new File(reader.getArg(1));
        boolean readingComplete = false;
        try {
            DocumentReader documentReader = ReadWriteFactory.getInstance().getReader(source);
            if (reader != null) {
                ReadWriteParameterMap parameterMap = new ReadWriteParameterMap();
                parameterMap.putApplicationLogger(CmdLoadLogger.getInstance());
                parameterMap.put("internalNodeNamesAdapter", new TextLabelAdapter(DEFAULT_LABEL_ID, new DecimalFormat("0.0#####")));
                Document document = documentReader.read(source, parameterMap);
                readingComplete = true;
                ReadWriteFormat format = null;
                if (XTG_OPTION.equals(reader.getArg(2))) {
                    format = ReadWriteFormat.XTG;
                } else if (NEWICK_OPTION.equals(reader.getArg(2))) {
                    format = ReadWriteFormat.NEWICK;
                } else if (NEXUS_OPTION.equals(reader.getArg(2))) {
                    format = ReadWriteFormat.NEXUS;
                }
                if (format != null) {
                    File dest = new File(reader.getArg(3));
                    if (dest.exists()) {
                        System.out.println("The file \"" + dest.getAbsolutePath() + "\" already exists. Output aborted.");
                    } else {
                        ReadWriteFactory.getInstance().getWriter(format).write(document, dest);
                        System.out.println("Output to \"" + reader.getArg(3) + "\" completed.");
                    }
                } else {
                    System.out.println("\"" + reader.getArg(2) + "\" is not a valid target format.");
                    System.out.println("(See http://r.bioinfweb.info/TGCMD for details.)");
                }
            }
        }
        catch (FileNotFoundException e) {
            String path = readingComplete ? reader.getArg(3) : source.getAbsolutePath();
            System.out.println("The file \"" + path + "\" could not be found.");
        }
        catch (Exception e) {
            System.out.println("The exception \"" + e.toString() + "\" occurred.");
        }
    }

    public void process(CommandLineReader reader) {
        if (reader.argCount() > 0 && reader.getArg(0).equals(VERSION_OPTION)) {
            System.out.println(Main.getInstance().getVersion());
        } else if (reader.argCount() >= 3 && reader.getArg(0).toLowerCase().equals(CONVERT_OPTION)) {
            this.convert(reader);
        } else if (reader.argCount() >= 3 && reader.getArg(0).toLowerCase().equals(IMAGE_OPTION)) {
            ImageGenerator.generate(reader);
        } else {
            if (reader.argCount() == 1) {
                this.initialFile = new File(reader.getArg(0));
            }
            this.startUI();
        }
    }
}

