/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph;

import info.bioinfweb.commons.CommandLineReader;
import info.bioinfweb.commons.ProgramMainClass;
import info.bioinfweb.commons.appversion.ApplicationType;
import info.bioinfweb.commons.appversion.ApplicationVersion;
import info.bioinfweb.commons.io.DefaultNameManager;
import info.bioinfweb.errorreport.swing.SwingErrorReporter;
import info.bioinfweb.treegraph.AWTExceptionHandler;
import info.bioinfweb.treegraph.cmd.CmdProcessor;
import info.bioinfweb.treegraph.document.clipboard.TreeClipboard;
import info.bioinfweb.wikihelp.client.WikiHelp;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SplashScreen;

public class Main
extends ProgramMainClass {
    public static final String CONFIG_DIR = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".TreeGraph2";
    public static final String TG_URL = "http://treegraph.bioinfweb.info/";
    public static final String ERROR_URL = "http://treegraph.bioinfweb.info/errorreport/ApplicationReport.jsp";
    public static final String WIKI_URL = "http://treegraph.bioinfweb.info/Help/";
    public static final String LATEST_VERSION_URL = "http://treegraph.bioinfweb.info/UpdateCenter/App/VersionList.jsp";
    public static final String DOWNLOAD_URL = "http://treegraph.bioinfweb.info/UpdateCenter/App/DownloadPage.jsp";
    public static final Font SPLASH_SCREEN_FONT = new Font("Dialog", 0, 12);
    public static final Color SPLASH_SCREEN_FONT_COLOR = Color.BLACK;
    public static final int SPLASH_SCREEN_BORDER = 4;
    private static Main firstInstance = null;
    private SwingErrorReporter errorReporter;
    private WikiHelp wikiHelp = new WikiHelp("http://treegraph.bioinfweb.info/Help/");
    private TreeClipboard clipboard = new TreeClipboard();
    private CmdProcessor cmdProcessor = new CmdProcessor();
    private DefaultNameManager nameManager = new DefaultNameManager("NewTree");

    private Main() {
        super(new ApplicationVersion(2, 15, 0, 887L, ApplicationType.BETA));
        this.errorReporter = new SwingErrorReporter(ERROR_URL, this.getVersion());
    }

    public static Main getInstance() {
        if (firstInstance == null) {
            firstInstance = new Main();
        }
        return firstInstance;
    }

    public SwingErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public CmdProcessor getCmdProcessor() {
        return this.cmdProcessor;
    }

    public WikiHelp getWikiHelp() {
        return this.wikiHelp;
    }

    public TreeClipboard getClipboard() {
        return this.clipboard;
    }

    public DefaultNameManager getNameManager() {
        return this.nameManager;
    }

    private void customizeSpashScreen() {
        Graphics2D g;
        SplashScreen splash = SplashScreen.getSplashScreen();
        if (splash != null && (g = splash.createGraphics()) != null) {
            Dimension size = splash.getSize();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setComposite(AlphaComposite.Clear);
            g.setPaintMode();
            FontMetrics fm = g.getFontMetrics();
            String text = this.getVersion().toString();
            g.setColor(Color.BLACK);
            g.drawString(text, (int)size.getWidth() - fm.stringWidth(text) - 4, (int)size.getHeight() - 4);
            splash.update();
        }
    }

    private void startApplication(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)this.getErrorReporter());
        System.setProperty("sun.awt.exception.handler", AWTExceptionHandler.class.getName());
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "TreeGraph 2");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        this.customizeSpashScreen();
        this.cmdProcessor.process(new CommandLineReader(args));
    }

    public static void main(String[] args) {
        Main.getInstance().startApplication(args);
    }
}

