/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.utils;

import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.TreeNetworkDataAdapter;
import info.bioinfweb.jphyloio.events.EdgeEvent;
import info.bioinfweb.jphyloio.utils.TopoplogicalNodeInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TreeTopologyExtractor {
    private Map<String, TopoplogicalNodeInfo> idToNodeInfoMap = new HashMap<String, TopoplogicalNodeInfo>();
    private Set<String> networkEdges = new HashSet<String>();
    private String paintStartID;

    public TreeTopologyExtractor(TreeNetworkDataAdapter treeNetworkDataAdapter, ReadWriteParameterMap readWriteParameterMap) {
        this.fillTopologicalMap(treeNetworkDataAdapter, readWriteParameterMap);
    }

    private void fillTopologicalMap(TreeNetworkDataAdapter treeNetworkDataAdapter, ReadWriteParameterMap readWriteParameterMap) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<String> iterator = treeNetworkDataAdapter.getNodes(readWriteParameterMap).getIDIterator(readWriteParameterMap);
        while (iterator.hasNext()) {
            object = iterator.next();
            hashSet.add((String)object);
            this.idToNodeInfoMap.put((String)object, new TopoplogicalNodeInfo());
        }
        object = treeNetworkDataAdapter.getEdges(readWriteParameterMap).getIDIterator(readWriteParameterMap);
        while (object.hasNext()) {
            String string = (String)object.next();
            EdgeEvent edgeEvent = treeNetworkDataAdapter.getEdges(readWriteParameterMap).getObjectStartEvent(readWriteParameterMap, string);
            TopoplogicalNodeInfo topoplogicalNodeInfo = this.idToNodeInfoMap.get(edgeEvent.getSourceID());
            TopoplogicalNodeInfo topoplogicalNodeInfo2 = this.idToNodeInfoMap.get(edgeEvent.getTargetID());
            if (topoplogicalNodeInfo2.getParentNodeID() == null) {
                topoplogicalNodeInfo2.setParentNodeID(edgeEvent.getSourceID());
                topoplogicalNodeInfo2.setAfferentBranchID(edgeEvent.getID());
                if (topoplogicalNodeInfo == null) continue;
                topoplogicalNodeInfo.getChildNodeIDs().add(edgeEvent.getTargetID());
                hashSet.remove(edgeEvent.getTargetID());
                continue;
            }
            this.networkEdges.add(edgeEvent.getID());
        }
        if (hashSet.size() == 1) {
            this.paintStartID = (String)hashSet.iterator().next();
        }
    }

    public Map<String, TopoplogicalNodeInfo> getIDToNodeInfoMap() {
        return this.idToNodeInfoMap;
    }

    public String getPaintStartID() {
        return this.paintStartID;
    }

    public Set<String> getNetworkEdgeIDs() {
        return this.networkEdges;
    }
}

