/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.utils;

import info.bioinfweb.jphyloio.JPhyloIOEventReader;
import info.bioinfweb.jphyloio.events.SequenceTokensEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SequenceTokensEventManager {
    private JPhyloIOEventReader owner;
    private String matchToken;
    private List<String> firstSequence;
    private List<String> unmodifiableFirstSequence;
    private long currentPosition = 0L;
    private long currentBlockStartPosition = 0L;
    private long currentBlockLength = 0L;
    private String firstSequenceName = null;
    private String currentSequenceName = null;

    public SequenceTokensEventManager(JPhyloIOEventReader jPhyloIOEventReader, String string) {
        if (jPhyloIOEventReader == null) {
            throw new NullPointerException("owner cannot be null.");
        }
        this.owner = jPhyloIOEventReader;
        this.matchToken = string;
        this.firstSequence = new ArrayList<String>();
        this.unmodifiableFirstSequence = Collections.unmodifiableList(this.firstSequence);
    }

    public JPhyloIOEventReader getOwner() {
        return this.owner;
    }

    public String getMatchToken() {
        return this.matchToken;
    }

    public void setMatchToken(String string) {
        this.matchToken = string;
    }

    public long getCurrentPosition() {
        return this.currentPosition;
    }

    public long getCurrentBlockStartPosition() {
        return this.currentBlockStartPosition;
    }

    public long getCurrentBlockLength() {
        return this.currentBlockLength;
    }

    public String getFirstSequenceName() {
        return this.firstSequenceName;
    }

    public String getCurrentSequenceName() {
        return this.currentSequenceName;
    }

    public List<String> getFirstSequence() {
        return this.unmodifiableFirstSequence;
    }

    private String replaceMatchToken(String string) {
        if (string.equals(this.matchToken)) {
            if (this.currentPosition > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Sequences with more than 2147483647 characters are not supported if replacing match tokens is switched on.");
            }
            if (this.currentPosition >= (long)this.firstSequence.size()) {
                throw new IndexOutOfBoundsException("The match token in column " + this.currentPosition + " cannot be replaced because the first sequence only has " + this.firstSequence.size() + " characters.");
            }
            return this.firstSequence.get((int)this.currentPosition);
        }
        return string;
    }

    public SequenceTokensEvent createEvent(String string, List<String> list) {
        boolean bl;
        if (string == null || list == null) {
            throw new NullPointerException("Sequence names must not be null.");
        }
        boolean bl2 = bl = !string.equals(this.currentSequenceName);
        if (bl) {
            this.currentSequenceName = string;
            this.currentPosition = this.currentBlockStartPosition;
        }
        if (this.firstSequenceName == null) {
            this.firstSequenceName = string;
        }
        if (this.firstSequenceName.equals(string)) {
            this.firstSequence.addAll(list);
            if (bl) {
                this.currentBlockStartPosition += this.currentBlockLength;
                this.currentBlockLength = list.size();
                this.currentPosition = this.currentBlockStartPosition;
            } else {
                this.currentBlockLength += (long)list.size();
            }
            this.currentPosition += (long)list.size();
        } else if (this.matchToken != null) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, this.replaceMatchToken(list.get(i)));
                ++this.currentPosition;
            }
        } else {
            this.currentPosition += (long)list.size();
        }
        return new SequenceTokensEvent(list);
    }
}

