/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.utils;

import info.bioinfweb.jphyloio.events.LabeledIDEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LabelEditingReporter {
    private Map<EventContentType, ContentTypeEntry> translations = new EnumMap<EventContentType, ContentTypeEntry>(EventContentType.class);

    private ContentTypeEntry getContentTypeEntry(EventContentType eventContentType) {
        if (eventContentType == null) {
            throw new NullPointerException("The content type must not be null.");
        }
        ContentTypeEntry contentTypeEntry = this.translations.get((Object)eventContentType);
        if (contentTypeEntry == null) {
            contentTypeEntry = new ContentTypeEntry();
            this.translations.put(eventContentType, contentTypeEntry);
        }
        return contentTypeEntry;
    }

    private LabelMapping getMapping(EventContentType eventContentType, String string) {
        return this.getContentTypeEntry((EventContentType)eventContentType).labelMappings.get(string);
    }

    public void addEdit(EventContentType eventContentType, String string, String string2, boolean bl) {
        if (string == null) {
            throw new NullPointerException("The specified ID must not be null.");
        }
        ContentTypeEntry contentTypeEntry = this.getContentTypeEntry(eventContentType);
        contentTypeEntry.labelMappings.put(string, new LabelMapping(string2, bl));
        contentTypeEntry.usedLabels.add(string2);
    }

    public void addEdit(LabeledIDEvent labeledIDEvent, String string) {
        this.addEdit(labeledIDEvent.getType().getContentType(), labeledIDEvent.getID(), string, string == null || !string.equals(labeledIDEvent.getLabel()));
    }

    public void clear() {
        this.translations.clear();
    }

    public String getEditedLabel(EventContentType eventContentType, String string) {
        LabelMapping labelMapping = this.getMapping(eventContentType, string);
        if (labelMapping == null) {
            return null;
        }
        return labelMapping.label;
    }

    public String getEditedLabel(LabeledIDEvent labeledIDEvent) {
        return this.getEditedLabel(labeledIDEvent.getType().getContentType(), labeledIDEvent.getID());
    }

    public LabelStatus getLabelStatus(EventContentType eventContentType, String string) {
        LabelMapping labelMapping = this.getContentTypeEntry((EventContentType)eventContentType).labelMappings.get(string);
        if (labelMapping == null) {
            return LabelStatus.NOT_FOUND;
        }
        if (labelMapping.wasNotWritten()) {
            return LabelStatus.NOT_WRITTEN;
        }
        if (labelMapping.edited) {
            return LabelStatus.EDITED;
        }
        return LabelStatus.UNCHANGED;
    }

    public LabelStatus getLabelStatus(LabeledIDEvent labeledIDEvent) {
        return this.getLabelStatus(labeledIDEvent.getType().getContentType(), labeledIDEvent.getID());
    }

    public boolean isLabelUsed(EventContentType eventContentType, String string) {
        return this.getContentTypeEntry((EventContentType)eventContentType).usedLabels.contains(string);
    }

    public boolean anyLabelEdited(EventContentType eventContentType) {
        Map<String, LabelMapping> map = this.getContentTypeEntry((EventContentType)eventContentType).labelMappings;
        for (String string : map.keySet()) {
            if (!map.get((Object)string).edited) continue;
            return true;
        }
        return false;
    }

    public static enum LabelStatus {
        UNCHANGED,
        EDITED,
        NOT_WRITTEN,
        NOT_FOUND;

    }

    private static class LabelMapping {
        public String label;
        public boolean edited;

        public LabelMapping(String string, boolean bl) {
            this.label = string;
            this.edited = bl;
        }

        public boolean wasNotWritten() {
            return this.label == null;
        }
    }

    private static class ContentTypeEntry {
        public Map<String, LabelMapping> labelMappings = new HashMap<String, LabelMapping>();
        public Set<String> usedLabels = new HashSet<String>();

        private ContentTypeEntry() {
        }
    }
}

