/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.utils;

import info.bioinfweb.commons.text.StringUtils;
import info.bioinfweb.jphyloio.dataadapters.JPhyloIOEventReceiver;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.SequenceTokensEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class JPhyloIOWritingUtils {
    private static List<String> createTokenList(int n) {
        return new ArrayList<String>(Math.min(2048, n));
    }

    public static void writeCharSequencePartContent(JPhyloIOEventReceiver jPhyloIOEventReceiver, long l, long l2, CharSequence charSequence) throws IOException, IllegalArgumentException {
        l = Math.max(0L, l);
        l2 = Math.min((long)charSequence.length(), l2);
        jPhyloIOEventReceiver.add(new SequenceTokensEvent(StringUtils.charSequenceToStringList((CharSequence)charSequence.subSequence((int)l, (int)l2))));
    }

    public static void writeListSequencePartContent(JPhyloIOEventReceiver jPhyloIOEventReceiver, long l, long l2, List<?> list) throws IOException, IllegalArgumentException {
        l = Math.max(0L, l);
        l2 = Math.min((long)list.size(), l2);
        int n = (int)(l2 - l);
        int n2 = 0;
        List<String> list2 = JPhyloIOWritingUtils.createTokenList(n);
        for (Object obj : list) {
            list2.add(obj.toString());
            if (n2 < 2048) continue;
            jPhyloIOEventReceiver.add(new SequenceTokensEvent(list2));
            n2 = 0;
            list2 = JPhyloIOWritingUtils.createTokenList(n);
        }
        if (n2 > 0) {
            jPhyloIOEventReceiver.add(new SequenceTokensEvent(list2));
        }
    }

    public static void writeSimpleLiteralMetadata(JPhyloIOEventReceiver jPhyloIOEventReceiver, String string, String string2, URIOrStringIdentifier uRIOrStringIdentifier, URIOrStringIdentifier uRIOrStringIdentifier2, Object object, String string3) throws IOException {
        jPhyloIOEventReceiver.add(new LiteralMetadataEvent(string, string2, uRIOrStringIdentifier, uRIOrStringIdentifier2, LiteralContentSequenceType.SIMPLE));
        if (object != null || string3 != null) {
            jPhyloIOEventReceiver.add(new LiteralMetadataContentEvent(object, string3));
        }
        jPhyloIOEventReceiver.add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
    }

    public static void writeSimpleLiteralMetadata(JPhyloIOEventReceiver jPhyloIOEventReceiver, String string, String string2, QName qName, QName qName2, Object object, String string3) throws IOException {
        JPhyloIOWritingUtils.writeSimpleLiteralMetadata(jPhyloIOEventReceiver, string, string2, new URIOrStringIdentifier(null, qName), new URIOrStringIdentifier(null, qName2), object, string3);
    }

    public static void writeSimpleLiteralMetadata(JPhyloIOEventReceiver jPhyloIOEventReceiver, String string, String string2, QName qName, QName qName2, Object object) throws IOException {
        JPhyloIOWritingUtils.writeSimpleLiteralMetadata(jPhyloIOEventReceiver, string, string2, qName, qName2, object, null);
    }

    public static void writeTerminalResourceMetadata(JPhyloIOEventReceiver jPhyloIOEventReceiver, String string, String string2, URIOrStringIdentifier uRIOrStringIdentifier, URI uRI, String string3) throws IOException {
        jPhyloIOEventReceiver.add(new ResourceMetadataEvent(string, string2, uRIOrStringIdentifier, uRI, string3));
        jPhyloIOEventReceiver.add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.RESOURCE_META));
    }

    public static void writeTerminalResourceMetadata(JPhyloIOEventReceiver jPhyloIOEventReceiver, String string, String string2, URIOrStringIdentifier uRIOrStringIdentifier, URI uRI) throws IOException {
        JPhyloIOWritingUtils.writeTerminalResourceMetadata(jPhyloIOEventReceiver, string, string2, uRIOrStringIdentifier, uRI, null);
    }

    public static void writeTerminalResourceMetadata(JPhyloIOEventReceiver jPhyloIOEventReceiver, String string, String string2, QName qName, URI uRI, String string3) throws IOException {
        JPhyloIOWritingUtils.writeTerminalResourceMetadata(jPhyloIOEventReceiver, string, string2, new URIOrStringIdentifier(null, qName), uRI, string3);
    }

    public static void writeTerminalResourceMetadata(JPhyloIOEventReceiver jPhyloIOEventReceiver, String string, String string2, QName qName, URI uRI) throws IOException {
        JPhyloIOWritingUtils.writeTerminalResourceMetadata(jPhyloIOEventReceiver, string, string2, qName, uRI, null);
    }
}

