/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.push;

import info.bioinfweb.jphyloio.JPhyloIOEventReader;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.push.JPhyloIOEventListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class EventForwarder {
    private List<JPhyloIOEventListener> listeners = new ArrayList<JPhyloIOEventListener>();

    public List<JPhyloIOEventListener> getListeners() {
        return this.listeners;
    }

    public void readAll(JPhyloIOEventReader jPhyloIOEventReader) throws IOException {
        this.doReadUntil(jPhyloIOEventReader, null);
    }

    public void readUntil(JPhyloIOEventReader jPhyloIOEventReader, EventContentType eventContentType) throws IOException {
        this.doReadUntil(jPhyloIOEventReader, EnumSet.of(eventContentType));
    }

    public void readUntil(JPhyloIOEventReader jPhyloIOEventReader, Set<EventContentType> set) throws IOException {
        this.doReadUntil(jPhyloIOEventReader, set);
    }

    public void readCurrentNode(JPhyloIOEventReader jPhyloIOEventReader) throws IOException {
        if (jPhyloIOEventReader.hasNextEvent() && jPhyloIOEventReader.peek().getType().getTopologyType().equals((Object)EventTopologyType.START)) {
            this.fireNextEvent(jPhyloIOEventReader);
            int n = jPhyloIOEventReader.getParentInformation().size();
            do {
                this.fireNextEvent(jPhyloIOEventReader);
            } while (n < jPhyloIOEventReader.getParentInformation().size());
        } else {
            throw new IllegalArgumentException("The specified reader is not positioned at the start event.");
        }
    }

    private void doReadUntil(JPhyloIOEventReader jPhyloIOEventReader, Set<EventContentType> set) throws IOException {
        while (jPhyloIOEventReader.hasNextEvent() && (set == null || !set.contains(jPhyloIOEventReader.peek().getType()))) {
            this.fireNextEvent(jPhyloIOEventReader);
        }
    }

    private void fireNextEvent(JPhyloIOEventReader jPhyloIOEventReader) throws IOException {
        JPhyloIOEvent jPhyloIOEvent = jPhyloIOEventReader.next();
        for (JPhyloIOEventListener jPhyloIOEventListener : this.listeners) {
            jPhyloIOEventListener.processEvent(jPhyloIOEventReader, jPhyloIOEvent);
        }
    }
}

