/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.objecttranslation.implementations;

import info.bioinfweb.jphyloio.ReaderStreamDataProvider;
import info.bioinfweb.jphyloio.WriterStreamDataProvider;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.objecttranslation.InvalidObjectSourceDataException;
import info.bioinfweb.jphyloio.objecttranslation.implementations.AbstractObjectTranslator;
import java.io.IOException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class SimpleValueTranslator<O>
extends AbstractObjectTranslator<O> {
    public static final int MAX_STRING_REPRESENTATION_LENGTH = 16384;

    @Override
    public boolean hasStringRepresentation() {
        return true;
    }

    @Override
    public String javaToRepresentation(Object object, WriterStreamDataProvider<?> writerStreamDataProvider) throws UnsupportedOperationException, ClassCastException {
        return object.toString();
    }

    @Override
    public void writeXMLRepresentation(XMLStreamWriter xMLStreamWriter, Object object, WriterStreamDataProvider<?> writerStreamDataProvider) throws IOException, XMLStreamException {
        xMLStreamWriter.writeCharacters(this.javaToRepresentation(object, writerStreamDataProvider));
    }

    @Override
    public O readXMLRepresentation(XMLEventReader xMLEventReader, ReaderStreamDataProvider<?> readerStreamDataProvider) throws IOException, XMLStreamException, InvalidObjectSourceDataException {
        StringBuilder stringBuilder = new StringBuilder();
        while (xMLEventReader.peek().isCharacters()) {
            if (stringBuilder.length() > 16384) {
                throw new JPhyloIOReaderException("The text to parse a simple value from is longer than 16384 characters. Reading is aborted.", xMLEventReader.peek().getLocation());
            }
            stringBuilder.append(xMLEventReader.nextEvent().asCharacters().getData());
        }
        return this.representationToJava(stringBuilder.toString(), readerStreamDataProvider);
    }
}

