/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.objecttranslation.implementations;

import info.bioinfweb.jphyloio.ReaderStreamDataProvider;
import info.bioinfweb.jphyloio.WriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.JPhyloIOXMLEventReader;
import info.bioinfweb.jphyloio.formats.xml.JPhyloIOXMLEventWriter;
import info.bioinfweb.jphyloio.formats.xml.XMLReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.XMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.objecttranslation.implementations.IllegalArgumentExceptionSimpleValueTranslator;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class QNameTranslator
extends IllegalArgumentExceptionSimpleValueTranslator<QName> {
    @Override
    public Class<QName> getObjectClass() {
        return QName.class;
    }

    @Override
    protected QName parseValue(String string, ReaderStreamDataProvider<?> readerStreamDataProvider) throws IllegalArgumentException {
        if (readerStreamDataProvider instanceof XMLReaderStreamDataProvider) {
            return DatatypeConverter.parseQName((String)string, (NamespaceContext)((JPhyloIOXMLEventReader)readerStreamDataProvider.getEventReader()).getNamespaceContext());
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return new QName(string);
        }
        return new QName("", string.substring(n + 1), string.substring(0, n));
    }

    @Override
    public String javaToRepresentation(Object object, WriterStreamDataProvider<?> writerStreamDataProvider) throws UnsupportedOperationException, ClassCastException {
        QName qName = (QName)object;
        if (writerStreamDataProvider instanceof XMLWriterStreamDataProvider) {
            return DatatypeConverter.printQName((QName)qName, (NamespaceContext)((JPhyloIOXMLEventWriter)writerStreamDataProvider.getEventWriter()).getNamespaceContext());
        }
        if ("".equals(qName.getPrefix())) {
            return qName.getLocalPart();
        }
        return qName.getPrefix() + ":" + qName.getLocalPart();
    }
}

