/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.objecttranslation.implementations;

import info.bioinfweb.jphyloio.ReaderStreamDataProvider;
import info.bioinfweb.jphyloio.WriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.newick.NewickConstants;
import info.bioinfweb.jphyloio.formats.newick.NewickUtils;
import info.bioinfweb.jphyloio.objecttranslation.InvalidObjectSourceDataException;
import info.bioinfweb.jphyloio.objecttranslation.implementations.SimpleValueTranslator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListTranslator
extends SimpleValueTranslator<List<Object>>
implements NewickConstants {
    @Override
    public Class<List<Object>> getObjectClass() {
        return List.class;
    }

    public static List<Object> parseList(String string) throws InvalidObjectSourceDataException {
        if ((string = string.trim()).startsWith("{") && string.endsWith("}")) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            NewickUtils.ReadElement readElement = NewickUtils.readNextElement(string, 1, string.length() - 1);
            while (readElement != null) {
                if (readElement.getNumericValue() != null) {
                    arrayList.add(readElement.getNumericValue());
                } else {
                    arrayList.add(readElement.getText());
                }
                readElement = NewickUtils.readNextElement(string, readElement.getEndPos(), string.length() - 1);
            }
            return arrayList;
        }
        throw new InvalidObjectSourceDataException("List representations must be encolsed between '{' and '}'.");
    }

    @Override
    public List<Object> representationToJava(String string, ReaderStreamDataProvider<?> readerStreamDataProvider) throws InvalidObjectSourceDataException, UnsupportedOperationException {
        return ListTranslator.parseList(string);
    }

    public static String listToString(Iterable<?> iterable) throws ClassCastException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof Number) {
                stringBuilder.append(obj.toString());
            } else {
                stringBuilder.append('\'');
                stringBuilder.append(obj.toString().replaceAll("\\'", "''"));
                stringBuilder.append('\'');
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
            stringBuilder.append(' ');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public String javaToRepresentation(Object object, WriterStreamDataProvider<?> writerStreamDataProvider) throws ClassCastException {
        return ListTranslator.listToString((List)object);
    }
}

