/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.objecttranslation.implementations;

import info.bioinfweb.jphyloio.ReaderStreamDataProvider;
import info.bioinfweb.jphyloio.WriterStreamDataProvider;
import info.bioinfweb.jphyloio.objecttranslation.implementations.IllegalArgumentExceptionSimpleValueTranslator;

public class EnumTranslator<E extends Enum<E>>
extends IllegalArgumentExceptionSimpleValueTranslator<E> {
    private Class<E> enumClass;

    public EnumTranslator(Class<E> clazz) {
        if (clazz == null) {
            throw new NullPointerException("The enum class must not be null.");
        }
        this.enumClass = clazz;
    }

    @Override
    public Class<E> getObjectClass() {
        return this.enumClass;
    }

    @Override
    protected E parseValue(String string, ReaderStreamDataProvider<?> readerStreamDataProvider) throws IllegalArgumentException {
        return Enum.valueOf(this.enumClass, string);
    }

    @Override
    public String javaToRepresentation(Object object, WriterStreamDataProvider<?> writerStreamDataProvider) throws UnsupportedOperationException, ClassCastException {
        return ((Enum)this.enumClass.cast(object)).name();
    }
}

