/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.objecttranslation;

import info.bioinfweb.commons.io.W3CXSConstants;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.objecttranslation.ObjectTranslator;
import info.bioinfweb.jphyloio.objecttranslation.TranslatorMapKey;
import info.bioinfweb.jphyloio.objecttranslation.implementations.Base64BinaryTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.BigDecimalTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.BigIntegerTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.BooleanTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.ByteTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.DateTimeTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.DateTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.DoubleTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.FloatTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.HexBinaryTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.IntegerTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.ListTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.LongTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.QNameTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.ShortTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.StringTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.TimeTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.URITranslator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class ObjectTranslatorFactory
implements W3CXSConstants,
ReadWriteConstants {
    private Map<TranslatorMapKey, ObjectTranslator<?>> translatorMap = new HashMap();

    private void addTranslator(ObjectTranslator<?> objectTranslator, boolean bl, QName qName) {
        this.translatorMap.put(new TranslatorMapKey(qName, objectTranslator.getObjectClass()), objectTranslator);
        if (bl || this.getDefaultTranslator(qName) == null) {
            this.translatorMap.put(new TranslatorMapKey(qName, null), objectTranslator);
        }
    }

    public void addTranslator(ObjectTranslator<?> objectTranslator, boolean bl, QName qName, QName ... qNameArray) {
        this.addTranslator(objectTranslator, bl, qName);
        for (int i = 0; i < qNameArray.length; ++i) {
            this.addTranslator(objectTranslator, bl, qNameArray[i]);
        }
    }

    public void addXSDTranslators(boolean bl) {
        this.addTranslator(new StringTranslator(), bl, DATA_TYPE_STRING, DATA_TYPE_TOKEN);
        this.addTranslator(new BooleanTranslator(), bl, DATA_TYPE_BOOLEAN);
        this.addTranslator(new QNameTranslator(), bl, DATA_TYPE_QNAME);
        this.addTranslator(new URITranslator(), bl, DATA_TYPE_ANY_URI);
        this.addTranslator(new ByteTranslator(), bl, DATA_TYPE_BYTE);
        this.addTranslator(new ShortTranslator(), bl, DATA_TYPE_SHORT, DATA_TYPE_UNSIGNED_BYTE);
        this.addTranslator(new IntegerTranslator(), bl, DATA_TYPE_INT, DATA_TYPE_UNSIGNED_SHORT);
        this.addTranslator(new LongTranslator(), bl, DATA_TYPE_LONG, DATA_TYPE_UNSIGNED_INT);
        this.addTranslator(new BigIntegerTranslator(), bl, DATA_TYPE_INTEGER, DATA_TYPE_NON_POSITIVE_INTEGER, DATA_TYPE_NEGATIVE_INTEGER, DATA_TYPE_NON_NEGATIVE_INTEGER, DATA_TYPE_UNSIGNED_LONG, DATA_TYPE_POSITIVE_INTEGER);
        this.addTranslator(new FloatTranslator(), bl, DATA_TYPE_FLOAT);
        this.addTranslator(new DoubleTranslator(), bl, DATA_TYPE_DOUBLE);
        this.addTranslator(new BigDecimalTranslator(), bl, DATA_TYPE_DECIMAL);
        this.addTranslator(new DateTimeTranslator(), bl, DATA_TYPE_DATE_TIME);
        this.addTranslator(new DateTranslator(), bl, DATA_TYPE_DATE);
        this.addTranslator(new TimeTranslator(), bl, DATA_TYPE_TIME);
        this.addTranslator(new Base64BinaryTranslator(), bl, DATA_TYPE_BASE_64_BINARY);
        this.addTranslator(new HexBinaryTranslator(), bl, DATA_TYPE_HEX_BINARY);
    }

    public void addJPhyloIOTranslators(boolean bl) {
        this.addTranslator(new ListTranslator(), bl, DATA_TYPE_SIMPLE_VALUE_LIST);
    }

    public <O> ObjectTranslator<O> getTranslator(QName qName, Class<O> clazz) {
        return this.translatorMap.get(new TranslatorMapKey(qName, clazz));
    }

    public ObjectTranslator<?> getDefaultTranslator(QName qName) {
        return this.getTranslator(qName, null);
    }

    public ObjectTranslator<?> getDefaultTranslatorWithPossiblyInvalidNamespace(QName qName) {
        ObjectTranslator<Object> objectTranslator = this.getTranslator(qName, null);
        if (objectTranslator == null && qName != null && qName.getNamespaceURI() != null && !qName.getNamespaceURI().isEmpty() && qName.getNamespaceURI().endsWith("#")) {
            objectTranslator = this.getDefaultTranslator(new QName(qName.getNamespaceURI().substring(0, qName.getNamespaceURI().length() - 1), qName.getLocalPart()));
        }
        return objectTranslator;
    }
}

