/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.xml.stax;

import info.bioinfweb.jphyloio.dataadapters.JPhyloIOEventReceiver;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.formats.xml.stax.AbstractMetaXMLWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class MetaXMLStreamWriter
extends AbstractMetaXMLWriter
implements XMLStreamWriter {
    private XMLEventFactory factory = XMLEventFactory.newInstance();
    private Stack<StartElement> encounteredStartElements = new Stack();

    public MetaXMLStreamWriter(JPhyloIOEventReceiver jPhyloIOEventReceiver, XMLStreamWriter xMLStreamWriter) {
        super(jPhyloIOEventReceiver, xMLStreamWriter);
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.getUnderlyingXMLWriter().getNamespaceContext();
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        return this.getUnderlyingXMLWriter().getPrefix(string);
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return this.getUnderlyingXMLWriter().getProperty(string);
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.getUnderlyingXMLWriter().setDefaultNamespace(string);
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.getUnderlyingXMLWriter().setNamespaceContext(namespaceContext);
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        this.getUnderlyingXMLWriter().setPrefix(string, string2);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        this.addContentEvent(this.factory.createAttribute(new QName(string2, string3, string), string4));
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        this.addContentEvent(this.factory.createAttribute(new QName(string, string2), string3));
    }

    @Override
    public void writeAttribute(String string, String string2) throws XMLStreamException {
        this.addContentEvent(this.factory.createAttribute(string, string2));
    }

    @Override
    public void writeCData(String string) throws XMLStreamException {
        this.addContentEvent(this.factory.createCData(string));
    }

    @Override
    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.addContentEvent(this.factory.createCharacters(new String(cArray, n, n2)));
    }

    @Override
    public void writeCharacters(String string) throws XMLStreamException {
        this.addContentEvent(this.factory.createCharacters(string));
    }

    @Override
    public void writeComment(String string) throws XMLStreamException {
        this.addContentEvent(this.factory.createComment(string));
    }

    @Override
    public void writeDTD(String string) throws XMLStreamException {
        this.addContentEvent(this.factory.createDTD(string));
    }

    @Override
    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.addContentEvent(this.factory.createNamespace(string));
    }

    @Override
    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.addContentEvent(this.factory.createStartElement(string, string3, string2));
        this.addContentEvent(this.factory.createEndElement(string, string3, string2));
    }

    @Override
    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.addContentEvent(this.factory.createStartElement(new QName(string, string2), Collections.emptyIterator(), Collections.emptyIterator()));
        this.addContentEvent(this.factory.createEndElement(new QName(string, string2), Collections.emptyIterator()));
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        this.addContentEvent(this.factory.createStartElement(new QName(string), Collections.emptyIterator(), Collections.emptyIterator()));
        this.addContentEvent(this.factory.createEndElement(new QName(string), Collections.emptyIterator()));
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.addContentEvent(this.factory.createEndDocument());
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this.encounteredStartElements.isEmpty()) {
            throw new XMLStreamException("One more end element than start element was found.");
        }
        this.addContentEvent(this.factory.createEndElement(this.encounteredStartElements.pop().getName(), Collections.emptyIterator()));
    }

    @Override
    public void writeEntityRef(String string) throws XMLStreamException {
        this.addContentEvent(this.factory.createEntityReference(string, null));
    }

    @Override
    public void writeNamespace(String string, String string2) throws XMLStreamException {
        this.addContentEvent(this.factory.createNamespace(string, string2));
    }

    @Override
    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this.addContentEvent(this.factory.createProcessingInstruction(string, string2));
    }

    @Override
    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.addContentEvent(this.factory.createProcessingInstruction(string, null));
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.addContentEvent(this.factory.createStartDocument());
    }

    @Override
    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.addContentEvent(this.factory.createStartDocument(string, string2));
    }

    @Override
    public void writeStartDocument(String string) throws XMLStreamException {
        this.addContentEvent(this.factory.createStartDocument(null, string));
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        StartElement startElement = this.factory.createStartElement(new QName(string3, string2, string), Collections.emptyIterator(), Collections.emptyIterator());
        this.encounteredStartElements.push(startElement);
        this.addContentEvent(startElement);
    }

    @Override
    public void writeStartElement(String string, String string2) throws XMLStreamException {
        StartElement startElement = this.factory.createStartElement(new QName(string, string2), Collections.emptyIterator(), Collections.emptyIterator());
        this.encounteredStartElements.push(startElement);
        this.addContentEvent(startElement);
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        StartElement startElement = this.factory.createStartElement(new QName(string), Collections.emptyIterator(), Collections.emptyIterator());
        this.encounteredStartElements.push(startElement);
        this.addContentEvent(startElement);
    }

    private void addContentEvent(XMLEvent xMLEvent) throws XMLStreamException {
        try {
            this.getReceiver().add(new LiteralMetadataContentEvent(xMLEvent, false));
        }
        catch (IOException iOException) {
            if (iOException.getCause() != null) {
                throw new XMLStreamException(iOException.getCause());
            }
            throw new XMLStreamException("The created content event could not be added to the data receiver.");
        }
    }
}

