/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.xml.stax;

import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.events.type.EventType;
import info.bioinfweb.jphyloio.formats.xml.XMLReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.stax.AbstractMetaXMLReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.XMLEvent;

public class MetaXMLEventReader
extends AbstractMetaXMLReader
implements XMLEventReader {
    public MetaXMLEventReader(XMLReaderStreamDataProvider<?> xMLReaderStreamDataProvider) {
        super(xMLReaderStreamDataProvider);
    }

    @Override
    public Object next() throws NoSuchElementException {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new NoSuchElementException(xMLStreamException.getLocalizedMessage());
        }
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("A passed event stream cannot be modified.");
    }

    @Override
    public String getElementText() throws XMLStreamException {
        XMLEvent xMLEvent;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getJPhyloIOEventReader().getPreviousEvent().getType().getContentType().equals((Object)EventContentType.LITERAL_META_CONTENT) && (xMLEvent = this.getJPhyloIOEventReader().getPreviousEvent().asLiteralMetadataContentEvent().getXMLEvent()).getEventType() != 1) {
            throw new XMLStreamException("To read the next element text this reader must be positioned on a start element.");
        }
        xMLEvent = this.nextEvent();
        int n = xMLEvent.getEventType();
        while (n != 2) {
            switch (n) {
                case 4: 
                case 6: 
                case 12: {
                    stringBuffer.append(xMLEvent.asCharacters().getData());
                    break;
                }
                case 9: {
                    stringBuffer.append(((EntityReference)xMLEvent).getDeclaration().getReplacementText());
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 8: {
                    throw new XMLStreamException("The end of the document was reached while reading element text content.");
                }
                case 1: {
                    throw new XMLStreamException("Only text elements are allowed to be nested while reading element text content.");
                }
                default: {
                    throw new XMLStreamException("An unexpected event type was encountered while reading element text content.");
                }
            }
            xMLEvent = this.nextEvent();
            n = xMLEvent.getEventType();
        }
        return stringBuffer.toString();
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent xMLEvent;
        if (!this.isEndReached()) {
            if (this.getJPhyloIOEventReader().getPreviousEvent().getType().equals(new EventType(EventContentType.LITERAL_META, EventTopologyType.START)) && !this.isStartDocumentFired()) {
                xMLEvent = this.getEventFactory().createStartDocument();
                this.setStartDocumentFired(true);
            } else {
                try {
                    xMLEvent = this.obtainXMLContentEvent(this.getJPhyloIOEventReader().next());
                }
                catch (IOException iOException) {
                    if (iOException.getCause() != null) {
                        throw new XMLStreamException(iOException.getCause());
                    }
                    throw new XMLStreamException("No event could be obtained from the underlying reader.");
                }
            }
        } else if (!this.isEndDocumentFired()) {
            xMLEvent = this.getEventFactory().createEndDocument();
            this.setEndDocumentFired(true);
        } else {
            throw new NoSuchElementException("The end of this XML metadata stream was already reached.");
        }
        return xMLEvent;
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent xMLEvent = this.nextEvent();
        int n = xMLEvent.getEventType();
        while (xMLEvent.isCharacters() && xMLEvent.asCharacters().isWhiteSpace() || n == 3 || n == 5) {
            xMLEvent = this.nextEvent();
            n = xMLEvent.getEventType();
        }
        if (n != 1 && n != 2) {
            throw new XMLStreamException("An element that could not be skipped was encountered before the next start or end element.");
        }
        return xMLEvent;
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        XMLEvent xMLEvent = null;
        if (!this.isEndReached()) {
            if (this.getJPhyloIOEventReader().getPreviousEvent().getType().equals(new EventType(EventContentType.LITERAL_META, EventTopologyType.START)) && !this.isStartDocumentFired()) {
                xMLEvent = this.getEventFactory().createStartDocument();
            } else {
                try {
                    xMLEvent = this.obtainXMLContentEvent(this.getJPhyloIOEventReader().peek());
                }
                catch (IOException iOException) {
                    if (iOException.getCause() != null) {
                        throw new XMLStreamException(iOException.getCause());
                    }
                    throw new XMLStreamException("No XML event could be obtained from the underlying reader.");
                }
            }
        } else if (!this.isEndDocumentFired()) {
            xMLEvent = this.getEventFactory().createEndDocument();
        }
        return xMLEvent;
    }
}

