/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.xml.elementreaders;

import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.formats.xml.AttributeInfo;
import info.bioinfweb.jphyloio.formats.xml.XMLReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.elementreaders.AbstractXMLElementReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XMLStartElementReader
extends AbstractXMLElementReader {
    private QName literalPredicate;
    private QName resourcePredicate;
    private URIOrStringIdentifier datatype;
    private boolean isEdgeMeta;
    private LinkedHashMap<QName, AttributeInfo> attributeInformationMap;

    public XMLStartElementReader(QName qName, QName qName2, URIOrStringIdentifier uRIOrStringIdentifier, boolean bl, AttributeInfo ... attributeInfoArray) {
        this.literalPredicate = qName;
        this.resourcePredicate = qName2;
        this.datatype = uRIOrStringIdentifier;
        this.isEdgeMeta = bl;
        this.attributeInformationMap = new LinkedHashMap();
        for (int i = 0; i < attributeInfoArray.length; ++i) {
            this.attributeInformationMap.put(attributeInfoArray[i].getAttributeName(), attributeInfoArray[i]);
        }
    }

    protected QName getResourcePredicate() {
        return this.resourcePredicate;
    }

    protected boolean isEdgeMeta() {
        return this.isEdgeMeta;
    }

    public LinkedHashMap<QName, AttributeInfo> getAttributeInformationMap() {
        return this.attributeInformationMap;
    }

    @Override
    public void readEvent(XMLReaderStreamDataProvider xMLReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
        StartElement startElement = xMLEvent.asStartElement();
        if (this.isEdgeMeta) {
            xMLReaderStreamDataProvider.setCurrentEventCollection(xMLReaderStreamDataProvider.getSourceNode().peek().getNestedEdgeEvents());
        }
        if (this.resourcePredicate != null) {
            xMLReaderStreamDataProvider.getCurrentEventCollection().add(new ResourceMetadataEvent("meta" + xMLReaderStreamDataProvider.getIDManager().createNewID(), null, new URIOrStringIdentifier(null, this.resourcePredicate), null, null));
            this.readAttributes(xMLReaderStreamDataProvider, startElement, "", this.attributeInformationMap);
        }
        if (this.literalPredicate != null) {
            xMLReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + xMLReaderStreamDataProvider.getIDManager().createNewID(), null, new URIOrStringIdentifier(null, this.literalPredicate), this.datatype, LiteralContentSequenceType.SIMPLE));
        }
    }
}

