/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.xml;

import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.factory.AbstractSingleReaderWriterFactory;
import java.io.Reader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class AbstractXMLFactory
extends AbstractSingleReaderWriterFactory {
    private QName rootTag;

    public AbstractXMLFactory(QName qName) {
        this.rootTag = qName;
    }

    protected QName getRootTag() {
        return this.rootTag;
    }

    protected boolean checkRootTag(StartElement startElement) {
        return true;
    }

    @Override
    public boolean checkFormat(Reader reader, ReadWriteParameterMap readWriteParameterMap) {
        try {
            XMLEvent xMLEvent;
            XMLEventReader xMLEventReader = XMLInputFactory.newInstance().createXMLEventReader(reader);
            if (xMLEventReader.nextEvent().getEventType() != 7) {
                return false;
            }
            do {
                if (!(xMLEvent = xMLEventReader.nextEvent()).isEndElement() && !xMLEvent.isEndDocument()) continue;
                return false;
            } while (!xMLEvent.isStartElement());
            StartElement startElement = xMLEvent.asStartElement();
            if (startElement.getName().getLocalPart().equals(this.getRootTag().getLocalPart())) {
                return this.checkRootTag(startElement);
            }
            return false;
        }
        catch (XMLStreamException xMLStreamException) {
            return false;
        }
    }
}

