/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.xml;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.jphyloio.AbstractEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.DocumentDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.JPhyloIOEventReceiver;
import info.bioinfweb.jphyloio.exception.JPhyloIOWriterException;
import info.bioinfweb.jphyloio.formats.xml.JPhyloIOXMLEventWriter;
import info.bioinfweb.jphyloio.formats.xml.XMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.stax.MetaXMLEventWriter;
import info.bioinfweb.jphyloio.formats.xml.stax.MetaXMLStreamWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class AbstractXMLEventWriter<P extends XMLWriterStreamDataProvider<? extends AbstractXMLEventWriter<P>>>
extends AbstractEventWriter<P>
implements JPhyloIOXMLEventWriter {
    private XMLStreamWriter xmlWriter;
    private ReadWriteParameterMap parameters;
    private ApplicationLogger logger;
    private DocumentDataAdapter document;

    protected XMLStreamWriter getXMLWriter() {
        return this.xmlWriter;
    }

    protected ReadWriteParameterMap getParameters() {
        return this.parameters;
    }

    protected ApplicationLogger getLogger() {
        return this.logger;
    }

    protected DocumentDataAdapter getDocument() {
        return this.document;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.getXMLWriter().getNamespaceContext();
    }

    protected abstract void doWriteDocument() throws IOException, XMLStreamException;

    @Override
    protected void doWriteDocument(DocumentDataAdapter documentDataAdapter, Writer writer, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        try {
            this.xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
            this.parameters = readWriteParameterMap;
            this.logger = readWriteParameterMap.getLogger();
            this.document = documentDataAdapter;
            this.xmlWriter.writeStartDocument();
            this.doWriteDocument();
            this.xmlWriter.writeEndDocument();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new JPhyloIOWriterException("An XML stream exception occured in the underlying XMLStreamWriter.", xMLStreamException);
        }
    }

    @Override
    public XMLEventWriter createMetaXMLEventWriter(JPhyloIOEventReceiver jPhyloIOEventReceiver) throws IllegalStateException {
        return new MetaXMLEventWriter(jPhyloIOEventReceiver, this.getXMLWriter());
    }

    @Override
    public XMLStreamWriter createMetaXMLStreamWriter(JPhyloIOEventReceiver jPhyloIOEventReceiver) throws IllegalStateException {
        return new MetaXMLStreamWriter(jPhyloIOEventReceiver, this.getXMLWriter());
    }
}

