/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.text;

import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.implementations.receivers.BasicEventReceiver;
import info.bioinfweb.jphyloio.events.CommentEvent;
import info.bioinfweb.jphyloio.formats.text.AbstractTextEventWriter;
import info.bioinfweb.jphyloio.formats.text.TextWriterStreamDataProvider;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;

public class BasicTextCommentEventReceiver<P extends TextWriterStreamDataProvider<? extends AbstractTextEventWriter<P>>>
extends BasicEventReceiver<P> {
    private String commentStart;
    private String commentEnd;

    public BasicTextCommentEventReceiver(P p, ReadWriteParameterMap readWriteParameterMap, String string, String string2) {
        super(p, readWriteParameterMap);
        this.commentStart = string;
        this.commentEnd = string2;
    }

    public String getCommentStart() {
        return this.commentStart;
    }

    public String getCommentEnd() {
        return this.commentEnd;
    }

    @Override
    protected void handleComment(CommentEvent commentEvent) throws IOException, XMLStreamException {
        BasicTextCommentEventReceiver.writeComment(this, commentEvent, this.commentStart, this.commentEnd);
    }

    public static void writeComment(BasicEventReceiver<?> basicEventReceiver, CommentEvent commentEvent, String string, String string2) throws IOException {
        Writer writer = ((TextWriterStreamDataProvider)basicEventReceiver.getStreamDataProvider()).getWriter();
        if (!basicEventReceiver.isInComment()) {
            writer.write(string);
        }
        String string3 = commentEvent.getContent();
        String string4 = string3.replaceAll(Pattern.quote(string2), "");
        writer.write(string4);
        if (!string3.equals(string4)) {
            basicEventReceiver.getLogger().addWarning("A comment inside a sequence contained one or more comment end symbols used by the target format. The according parts were removed from the comment.");
        }
        if (!commentEvent.isContinuedInNextEvent()) {
            writer.write(string2);
        }
    }
}

