/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phyloxml.receivers;

import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.WriterStreamDataProvider;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.phyloxml.PropertyOwner;
import info.bioinfweb.jphyloio.formats.phyloxml.receivers.PhyloXMLMetaDataReceiver;
import info.bioinfweb.jphyloio.objecttranslation.ObjectTranslator;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class PhyloXMLOnlyCustomXMLDataReceiver
extends PhyloXMLMetaDataReceiver {
    private boolean writeCustomXML;

    public PhyloXMLOnlyCustomXMLDataReceiver(PhyloXMLWriterStreamDataProvider phyloXMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, PropertyOwner propertyOwner) {
        super(phyloXMLWriterStreamDataProvider, readWriteParameterMap, propertyOwner);
    }

    @Override
    protected void handleLiteralContentMeta(LiteralMetadataContentEvent literalMetadataContentEvent) throws IOException, XMLStreamException {
        if (this.writeCustomXML) {
            if (!this.hasSimpleContent() && literalMetadataContentEvent.hasXMLEventValue()) {
                this.writeCustomXMLTag(literalMetadataContentEvent.getXMLEvent());
            } else {
                ObjectTranslator<?> objectTranslator;
                QName qName = null;
                if (this.getOriginalType() != null) {
                    qName = this.getOriginalType().getURI();
                }
                if ((objectTranslator = this.getParameterMap().getObjectTranslatorFactory().getDefaultTranslatorWithPossiblyInvalidNamespace(qName)) != null && !objectTranslator.hasStringRepresentation()) {
                    objectTranslator.writeXMLRepresentation(((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter(), literalMetadataContentEvent.getObjectValue(), (WriterStreamDataProvider<?>)this.getStreamDataProvider());
                }
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setLiteralContentIsContinued(literalMetadataContentEvent.isContinuedInNextEvent());
            }
        }
    }

    @Override
    protected void handleResourceMetaStart(ResourceMetadataEvent resourceMetadataEvent) throws IOException, XMLStreamException {
        this.writeCustomXML = false;
        if (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().contains(resourceMetadataEvent.getID()) && resourceMetadataEvent.getRel().getURI() != null && resourceMetadataEvent.getRel().getURI().equals(ReadWriteConstants.PREDICATE_HAS_CUSTOM_XML)) {
            switch (this.getParameterMap().getPhyloXMLMetadataTreatment()) {
                case NONE: {
                    break;
                }
                case LEAVES_ONLY: 
                case SEQUENTIAL: 
                case TOP_LEVEL_WITH_CHILDREN: 
                case TOP_LEVEL_WITHOUT_CHILDREN: {
                    this.writeCustomXML = true;
                }
            }
        }
        if (this.writeCustomXML) {
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(resourceMetadataEvent.getID());
        }
    }

    @Override
    protected void handleMetaEndEvent(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        super.handleMetaEndEvent(jPhyloIOEvent);
        if (jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.RESOURCE_META)) {
            this.writeCustomXML = false;
        }
    }
}

