/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phyloxml.receivers;

import info.bioinfweb.commons.io.W3CXSConstants;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.WriterStreamDataProvider;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.exception.JPhyloIOWriterException;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLConstants;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLMetaEventInfo;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.phyloxml.PropertyOwner;
import info.bioinfweb.jphyloio.formats.xml.XMLReadWriteUtils;
import info.bioinfweb.jphyloio.formats.xml.receivers.AbstractXMLDataReceiver;
import info.bioinfweb.jphyloio.objecttranslation.ObjectTranslator;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class PhyloXMLMetaDataReceiver
extends AbstractXMLDataReceiver<PhyloXMLWriterStreamDataProvider>
implements PhyloXMLConstants {
    public static final Set<QName> VALID_XSD_TYPES = new HashSet<QName>();
    private PropertyOwner propertyOwner;
    private boolean hasSimpleContent;
    private URIOrStringIdentifier literalPredicate;
    private URIOrStringIdentifier originalType;
    private boolean writeContent;
    private boolean writePropertyStart;
    private String currentLiteralMetaID;

    public PhyloXMLMetaDataReceiver(PhyloXMLWriterStreamDataProvider phyloXMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, PropertyOwner propertyOwner) {
        super(phyloXMLWriterStreamDataProvider, readWriteParameterMap);
        this.propertyOwner = propertyOwner;
        PhyloXMLMetaDataReceiver.fillValidXSDTypes();
    }

    public PropertyOwner getPropertyOwner() {
        return this.propertyOwner;
    }

    public boolean hasSimpleContent() {
        return this.hasSimpleContent;
    }

    public boolean isWriteContent() {
        return this.writeContent;
    }

    public URIOrStringIdentifier getOriginalType() {
        return this.originalType;
    }

    @Override
    protected void handleLiteralMetaStart(LiteralMetadataEvent literalMetadataEvent) throws IOException, XMLStreamException {
        this.writeContent = this.determineWriteMeta(literalMetadataEvent.getID(), literalMetadataEvent.getPredicate());
        if (this.writeContent) {
            this.hasSimpleContent = literalMetadataEvent.getSequenceType().equals((Object)LiteralContentSequenceType.SIMPLE);
            this.literalPredicate = literalMetadataEvent.getPredicate();
            this.originalType = literalMetadataEvent.getOriginalType();
            this.currentLiteralMetaID = literalMetadataEvent.getID();
            this.writePropertyStart = true;
        }
    }

    @Override
    protected void handleLiteralContentMeta(LiteralMetadataContentEvent literalMetadataContentEvent) throws IOException, XMLStreamException {
        if (this.writeContent && this.hasSimpleContent()) {
            ObjectTranslator<?> objectTranslator;
            String string = null;
            if (this.originalType == null || this.originalType.getURI() == null) {
                this.originalType = new URIOrStringIdentifier(null, W3CXSConstants.DATA_TYPE_STRING);
            }
            if ((objectTranslator = this.getParameterMap().getObjectTranslatorFactory().getDefaultTranslatorWithPossiblyInvalidNamespace(this.originalType.getURI())) == null && !VALID_XSD_TYPES.contains(this.originalType.getURI()) || objectTranslator != null && objectTranslator.hasStringRepresentation() && !VALID_XSD_TYPES.contains(this.originalType.getURI())) {
                this.originalType = new URIOrStringIdentifier(null, W3CXSConstants.DATA_TYPE_STRING);
            }
            if ((string = this.processLiteralContent(literalMetadataContentEvent, objectTranslator, this.originalType.getURI())) != null) {
                if (this.writePropertyStart) {
                    this.writePropertyTag(this.literalPredicate, this.originalType, null, false);
                    this.writePropertyStart = false;
                }
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeCharacters(string);
                if (!literalMetadataContentEvent.isContinuedInNextEvent()) {
                    ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeEndElement();
                }
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(this.currentLiteralMetaID);
            }
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setLiteralContentIsContinued(literalMetadataContentEvent.isContinuedInNextEvent());
        }
    }

    @Override
    protected void handleResourceMetaStart(ResourceMetadataEvent resourceMetadataEvent) throws IOException, XMLStreamException {
        if (this.determineWriteMeta(resourceMetadataEvent.getID(), resourceMetadataEvent.getRel()) && (resourceMetadataEvent.getRel().getURI() == null || !resourceMetadataEvent.getRel().getURI().equals(ReadWriteConstants.PREDICATE_HAS_CUSTOM_XML))) {
            String string = null;
            if (resourceMetadataEvent.getHRef() != null) {
                string = resourceMetadataEvent.getHRef().toString();
            }
            this.writePropertyTag(resourceMetadataEvent.getRel(), new URIOrStringIdentifier(null, W3CXSConstants.DATA_TYPE_ANY_URI), string, true);
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(resourceMetadataEvent.getID());
        }
    }

    @Override
    protected void handleMetaEndEvent(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        if (jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.LITERAL_META)) {
            this.originalType = null;
            this.writePropertyStart = false;
            if (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).isLiteralContentContinued()) {
                throw new InconsistentAdapterDataException("A literal meta end event was encounterd, although the last literal meta content event was marked to be continued in a subsequent event.");
            }
        }
    }

    protected void writePropertyTag(URIOrStringIdentifier uRIOrStringIdentifier, URIOrStringIdentifier uRIOrStringIdentifier2, String string, boolean bl) throws XMLStreamException, JPhyloIOWriterException {
        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeStartElement(TAG_PROPERTY.getLocalPart());
        if (uRIOrStringIdentifier.getURI() == null) {
            uRIOrStringIdentifier = new URIOrStringIdentifier(null, ReadWriteConstants.PREDICATE_HAS_LITERAL_METADATA);
        }
        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_REF.getLocalPart(), ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().getPrefix(uRIOrStringIdentifier.getURI().getNamespaceURI()) + ":" + uRIOrStringIdentifier.getURI().getLocalPart());
        if (uRIOrStringIdentifier2 == null || uRIOrStringIdentifier2.getURI() == null) {
            uRIOrStringIdentifier2 = new URIOrStringIdentifier(null, W3CXSConstants.DATA_TYPE_STRING);
        }
        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_DATATYPE.getLocalPart(), "xsd:" + uRIOrStringIdentifier2.getURI().getLocalPart());
        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_APPLIES_TO.getLocalPart(), this.propertyOwner.toString());
        if (string != null) {
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeCharacters(string);
        }
        if (bl) {
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeEndElement();
        }
    }

    protected void writeCustomXMLTag(XMLEvent xMLEvent) throws XMLStreamException {
        boolean bl = true;
        switch (xMLEvent.getEventType()) {
            case 1: {
                StartElement startElement = xMLEvent.asStartElement();
                if (!startElement.getName().getNamespaceURI().equals("http://www.phyloxml.org")) {
                    ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCustomXMLElements().push(xMLEvent.asStartElement().getName().getLocalPart());
                    break;
                }
                throw new InconsistentAdapterDataException("The element \"" + startElement.getName().getLocalPart() + "\" was not nested correctly.");
            }
            case 2: {
                try {
                    ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCustomXMLElements().pop();
                    break;
                }
                catch (EmptyStackException emptyStackException) {
                    throw new InconsistentAdapterDataException("One more end element than start elements was found in the nested custom XML.");
                }
            }
            case 4: 
            case 12: {
                if (!((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCustomXMLElements().isEmpty()) break;
                bl = false;
                this.getParameterMap().getLogger().addWarning("A character or CDATA element that was not nested in any custom XML tag was found, but could not be written since PhyloXML does not support this.");
                break;
            }
        }
        if (bl) {
            XMLReadWriteUtils.writeCustomXML(((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter(), this.getParameterMap(), xMLEvent);
        }
    }

    protected boolean determineWriteMeta(String string, URIOrStringIdentifier uRIOrStringIdentifier) {
        boolean bl = false;
        PhyloXMLMetaEventInfo phyloXMLMetaEventInfo = ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaEvents().get(string);
        if (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().contains(string)) {
            if (uRIOrStringIdentifier.getURI() == null || !uRIOrStringIdentifier.getURI().getNamespaceURI().equals("http://bioinfweb.info/xmlns/JPhyloIO/PhyloXML/Predicates/")) {
                switch (this.getParameterMap().getPhyloXMLMetadataTreatment()) {
                    case NONE: {
                        bl = false;
                        break;
                    }
                    case LEAVES_ONLY: {
                        bl = phyloXMLMetaEventInfo.getChildIDs().isEmpty();
                        break;
                    }
                    case SEQUENTIAL: {
                        bl = true;
                        break;
                    }
                    case TOP_LEVEL_WITH_CHILDREN: {
                        bl = phyloXMLMetaEventInfo.isTopLevel() && !phyloXMLMetaEventInfo.getChildIDs().isEmpty();
                        break;
                    }
                    case TOP_LEVEL_WITHOUT_CHILDREN: {
                        bl = phyloXMLMetaEventInfo.isTopLevel() && phyloXMLMetaEventInfo.getChildIDs().isEmpty();
                    }
                }
                return bl;
            }
            throw new InconsistentAdapterDataException("The meta event \"" + string + "\" with the PhyloXML-specific predicate \"" + uRIOrStringIdentifier.getURI().getLocalPart() + "\" was not nested correctly.");
        }
        return false;
    }

    protected String processLiteralContent(LiteralMetadataContentEvent literalMetadataContentEvent, ObjectTranslator<?> objectTranslator, QName qName) throws IOException, XMLStreamException {
        String string = null;
        if (literalMetadataContentEvent.hasObjectValue()) {
            if (objectTranslator != null && objectTranslator.hasStringRepresentation()) {
                try {
                    string = objectTranslator.javaToRepresentation(literalMetadataContentEvent.getObjectValue(), (WriterStreamDataProvider<?>)this.getStreamDataProvider());
                }
                catch (ClassCastException classCastException) {
                    throw new JPhyloIOWriterException("The original type of the object declared in this event did not match the actual object type. Therefore it could not be parsed.");
                }
            } else {
                string = literalMetadataContentEvent.hasStringValue() ? literalMetadataContentEvent.getStringValue() : literalMetadataContentEvent.getObjectValue().toString();
            }
        } else {
            string = literalMetadataContentEvent.getStringValue();
        }
        return string;
    }

    private static void fillValidXSDTypes() {
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_STRING);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_BOOLEAN);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_DECIMAL);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_FLOAT);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_DOUBLE);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_DURATION);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_DATE_TIME);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_TIME);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_DATE);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_G_YEAR_MONTH);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_G_YEAR);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_G_MONTH_DAY);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_G_DAY);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_G_MONTH);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_HEX_BINARY);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_BASE_64_BINARY);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_ANY_URI);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_NORMALIZED_STRING);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_TOKEN);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_INTEGER);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_NON_POSITIVE_INTEGER);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_NEGATIVE_INTEGER);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_LONG);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_INT);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_SHORT);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_BYTE);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_NON_NEGATIVE_INTEGER);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_UNSIGNED_LONG);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_UNSIGNED_INT);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_UNSIGNED_SHORT);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_UNSIGNED_BYTE);
        VALID_XSD_TYPES.add(W3CXSConstants.DATA_TYPE_POSITIVE_INTEGER);
    }
}

