/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phyloxml.receivers;

import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.CommentEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLConstants;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLMetaEventInfo;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.XMLReadWriteUtils;
import info.bioinfweb.jphyloio.formats.xml.XMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.receivers.AbstractXMLDataReceiver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class PhyloXMLCollectMetadataDataReceiver
extends AbstractXMLDataReceiver<PhyloXMLWriterStreamDataProvider>
implements PhyloXMLConstants {
    private Stack<String> metaIDs = new Stack();
    private boolean isPhylogenyIDValue = false;
    private boolean isPhylogenyIDProvider = false;
    private boolean isIDSource = false;
    private boolean hasMetadata = false;

    public PhyloXMLCollectMetadataDataReceiver(PhyloXMLWriterStreamDataProvider phyloXMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap) {
        super(phyloXMLWriterStreamDataProvider, readWriteParameterMap);
    }

    public boolean hasMetadata() {
        return this.hasMetadata;
    }

    public void resetHasMetadata() {
        this.hasMetadata = false;
    }

    @Override
    protected void handleLiteralMetaStart(LiteralMetadataEvent literalMetadataEvent) throws IOException, XMLStreamException {
        String string = literalMetadataEvent.getID();
        this.hasMetadata = true;
        if (!this.metaIDs.isEmpty()) {
            String string2 = this.metaIDs.peek();
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaEvents().get(string2).getChildIDs().add(string);
        }
        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaEvents().put(string, new PhyloXMLMetaEventInfo(string, new ArrayList<String>(), this.metaIDs.isEmpty()));
        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().add(string);
        this.metaIDs.add(string);
        if (literalMetadataEvent.getPredicate().getURI() != null) {
            QName qName = literalMetadataEvent.getPredicate().getURI();
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
            if (qName.equals(PREDICATE_PHYLOGENY_ID_ATTR_PROVIDER)) {
                this.isPhylogenyIDProvider = true;
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(literalMetadataEvent.getID());
            } else if (qName.equals(PREDICATE_PHYLOGENY_ID_VALUE)) {
                this.isPhylogenyIDValue = true;
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(literalMetadataEvent.getID());
            } else if (qName.equals(PREDICATE_ATTR_ID_SOURCE)) {
                this.isIDSource = true;
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(literalMetadataEvent.getID());
            }
        } else {
            QName qName = ReadWriteConstants.PREDICATE_HAS_LITERAL_METADATA;
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
        }
    }

    @Override
    protected void handleLiteralContentMeta(LiteralMetadataContentEvent literalMetadataContentEvent) throws IOException, XMLStreamException {
        XMLReadWriteUtils.manageLiteralContentMetaNamespaces((XMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameterMap(), literalMetadataContentEvent);
        if (literalMetadataContentEvent.hasStringValue()) {
            String string = literalMetadataContentEvent.getStringValue();
            if (this.isPhylogenyIDProvider) {
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setPhylogenyIDProvider(string);
                this.isPhylogenyIDProvider = false;
            } else if (this.isPhylogenyIDValue) {
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setPhylogenyID(string);
                this.isPhylogenyIDValue = false;
            } else if (this.isIDSource) {
                if (!((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getIdSources().add(string)) {
                    throw new InconsistentAdapterDataException("Duplicate value \"" + string + "\" found in attribute \"id_source\". All values of such an attribute need to be unique in the document.");
                }
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setCurrentCladeIDSource(string);
                this.isIDSource = false;
            }
        }
    }

    @Override
    protected void handleResourceMetaStart(ResourceMetadataEvent resourceMetadataEvent) throws IOException, XMLStreamException {
        String string = resourceMetadataEvent.getID();
        this.hasMetadata = true;
        if (!this.metaIDs.isEmpty()) {
            String string2 = this.metaIDs.peek();
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaEvents().get(string2).getChildIDs().add(string);
        }
        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaEvents().put(string, new PhyloXMLMetaEventInfo(string, new ArrayList<String>(), this.metaIDs.isEmpty()));
        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().add(string);
        this.metaIDs.add(string);
        if (resourceMetadataEvent.getRel().getURI() != null) {
            QName qName = resourceMetadataEvent.getRel().getURI();
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
            if (qName.equals(PREDICATE_PHYLOGENY_ID)) {
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(resourceMetadataEvent.getID());
            }
        } else {
            QName qName = ReadWriteConstants.PREDICATE_HAS_LITERAL_METADATA;
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
        }
    }

    @Override
    protected void handleMetaEndEvent(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        this.hasMetadata = true;
        this.metaIDs.pop();
        this.isPhylogenyIDProvider = false;
        this.isPhylogenyIDValue = false;
        this.isIDSource = false;
    }

    @Override
    protected void handleComment(CommentEvent commentEvent) throws IOException, XMLStreamException {
    }
}

