/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phyloxml.elementreader;

import info.bioinfweb.commons.io.W3CXSConstants;
import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLEventReader;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.elementreaders.AbstractXMLElementReader;
import info.bioinfweb.jphyloio.objecttranslation.InvalidObjectSourceDataException;
import info.bioinfweb.jphyloio.objecttranslation.ObjectTranslator;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class PhyloXMLCharactersElementReader
extends AbstractXMLElementReader<PhyloXMLReaderStreamDataProvider> {
    private QName datatype;

    public PhyloXMLCharactersElementReader(QName qName) {
        this.datatype = qName;
    }

    @Override
    public void readEvent(PhyloXMLReaderStreamDataProvider phyloXMLReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
        ObjectTranslator<PhyloXMLEventReader> objectTranslator = phyloXMLReaderStreamDataProvider.getParameters().getObjectTranslatorFactory().getDefaultTranslatorWithPossiblyInvalidNamespace(this.datatype);
        if (!this.datatype.equals(W3CXSConstants.DATA_TYPE_TOKEN) && !this.datatype.equals(W3CXSConstants.DATA_TYPE_STRING) && objectTranslator != null && objectTranslator.hasStringRepresentation()) {
            Object var4_4 = null;
            String string = xMLEvent.asCharacters().getData() + XMLUtils.readCharactersAsString((XMLEventReader)phyloXMLReaderStreamDataProvider.getXMLReader());
            if (string != null) {
                try {
                    var4_4 = objectTranslator.representationToJava(string, phyloXMLReaderStreamDataProvider);
                    phyloXMLReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataContentEvent(var4_4, string));
                }
                catch (InvalidObjectSourceDataException invalidObjectSourceDataException) {
                    throw new JPhyloIOReaderException("The content of this tag could not be parsed to class " + objectTranslator.getObjectClass().getSimpleName() + ".", xMLEvent.getLocation());
                }
            }
        } else {
            boolean bl = phyloXMLReaderStreamDataProvider.getXMLReader().peek().isCharacters();
            phyloXMLReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataContentEvent(xMLEvent.asCharacters().getData(), bl));
        }
    }
}

