/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phyloxml;

import info.bioinfweb.jphyloio.dataadapters.TreeNetworkDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.TreeNetworkGroupDataAdapter;
import info.bioinfweb.jphyloio.events.EdgeEvent;
import info.bioinfweb.jphyloio.events.LabeledIDEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.NodeEvent;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLConstants;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLPrivateConstants;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.phyloxml.PropertyOwner;
import info.bioinfweb.jphyloio.formats.phyloxml.receivers.PhyloXMLCollectMetadataDataReceiver;
import info.bioinfweb.jphyloio.formats.phyloxml.receivers.PhyloXMLMetaDataReceiver;
import info.bioinfweb.jphyloio.formats.phyloxml.receivers.PhyloXMLOnlyCustomXMLDataReceiver;
import info.bioinfweb.jphyloio.formats.phyloxml.receivers.PhyloXMLPropertyMetadataReceiver;
import info.bioinfweb.jphyloio.formats.phyloxml.receivers.PhyloXMLSpecificPredicatesDataReceiver;
import info.bioinfweb.jphyloio.formats.xml.AbstractXMLEventWriter;
import info.bioinfweb.jphyloio.formats.xml.XMLReadWriteUtils;
import info.bioinfweb.jphyloio.utils.TreeTopologyExtractor;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;

public class PhyloXMLEventWriter
extends AbstractXMLEventWriter<PhyloXMLWriterStreamDataProvider>
implements PhyloXMLConstants,
PhyloXMLPrivateConstants {
    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.phyloxml";
    }

    @Override
    protected PhyloXMLWriterStreamDataProvider createStreamDataProvider() {
        return new PhyloXMLWriterStreamDataProvider(this);
    }

    @Override
    protected void doWriteDocument() throws IOException, XMLStreamException {
        PhyloXMLOnlyCustomXMLDataReceiver phyloXMLOnlyCustomXMLDataReceiver = new PhyloXMLOnlyCustomXMLDataReceiver((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), PropertyOwner.OTHER);
        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setNamespacePrefix("xsd", "http://www.w3.org/2001/XMLSchema");
        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setNamespacePrefix(XMLReadWriteUtils.getXSIPrefix(this.getXMLWriter()), "http://www.w3.org/2001/XMLSchema-instance");
        this.checkDocument();
        this.getXMLWriter().writeStartElement(TAG_ROOT.getLocalPart());
        this.getXMLWriter().writeDefaultNamespace("http://www.phyloxml.org");
        for (String string : ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getNamespacePrefixes()) {
            this.getXMLWriter().writeNamespace(string, this.getXMLWriter().getNamespaceContext().getNamespaceURI(string));
        }
        this.getXMLWriter().writeAttribute(XMLReadWriteUtils.getXSIPrefix(this.getXMLWriter()), "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.phyloxml.org http://www.phyloxml.org/1.10/phyloxml.xsd");
        this.getXMLWriter().writeComment(" " + this.getFileStartInfo(this.getParameters()) + " ");
        if (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).isDocumentHasMetadata() || ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).isDocumentHasPhylogeny()) {
            this.writePhylogenyTags();
            this.getDocument().writeMetadata(this.getParameters(), phyloXMLOnlyCustomXMLDataReceiver);
        } else {
            this.getXMLWriter().writeStartElement(TAG_PHYLOGENY.getLocalPart());
            this.getXMLWriter().writeEndElement();
            this.getParameters().getLogger().addWarning("The document did not contain any data that could be written to the file.");
        }
        this.getXMLWriter().writeEndElement();
    }

    private void checkDocument() throws IOException {
        PhyloXMLCollectMetadataDataReceiver phyloXMLCollectMetadataDataReceiver = new PhyloXMLCollectMetadataDataReceiver((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters());
        this.getDocument().writeMetadata(this.getParameters(), phyloXMLCollectMetadataDataReceiver);
        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setDocumentHasMetadata(phyloXMLCollectMetadataDataReceiver.hasMetadata());
        Iterator<TreeNetworkGroupDataAdapter> iterator = this.getDocument().getTreeNetworkGroupIterator(this.getParameters());
        while (iterator.hasNext()) {
            TreeNetworkGroupDataAdapter treeNetworkGroupDataAdapter = iterator.next();
            phyloXMLCollectMetadataDataReceiver.resetHasMetadata();
            treeNetworkGroupDataAdapter.writeMetadata(this.getParameters(), phyloXMLCollectMetadataDataReceiver);
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setTreeGroupHasMetadata(phyloXMLCollectMetadataDataReceiver.hasMetadata());
            Iterator<TreeNetworkDataAdapter> iterator2 = treeNetworkGroupDataAdapter.getTreeNetworkIterator(this.getParameters());
            while (iterator2.hasNext()) {
                TreeNetworkDataAdapter treeNetworkDataAdapter = iterator2.next();
                treeNetworkDataAdapter.writeMetadata(this.getParameters(), phyloXMLCollectMetadataDataReceiver);
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setDocumentHasPhylogeny(true);
                Iterator<String> iterator3 = treeNetworkDataAdapter.getEdges(this.getParameters()).getIDIterator(this.getParameters());
                while (iterator3.hasNext()) {
                    treeNetworkDataAdapter.getEdges(this.getParameters()).writeContentData(this.getParameters(), phyloXMLCollectMetadataDataReceiver, iterator3.next());
                }
                Iterator<String> iterator4 = treeNetworkDataAdapter.getNodes(this.getParameters()).getIDIterator(this.getParameters());
                while (iterator4.hasNext()) {
                    String string = iterator4.next();
                    treeNetworkDataAdapter.getNodes(this.getParameters()).writeContentData(this.getParameters(), phyloXMLCollectMetadataDataReceiver, string);
                    ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getNodeEventIDToIDSourceMap().put(string, ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentCladeIDSource());
                    ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).setCurrentCladeIDSource(null);
                }
            }
        }
    }

    private void writePhylogenyTags() throws XMLStreamException, IOException {
        Iterator<TreeNetworkGroupDataAdapter> iterator = this.getDocument().getTreeNetworkGroupIterator(this.getParameters());
        while (iterator.hasNext()) {
            TreeNetworkGroupDataAdapter treeNetworkGroupDataAdapter = iterator.next();
            Iterator<TreeNetworkDataAdapter> iterator2 = treeNetworkGroupDataAdapter.getTreeNetworkIterator(this.getParameters());
            while (iterator2.hasNext()) {
                TreeNetworkDataAdapter treeNetworkDataAdapter = iterator2.next();
                this.writePhylogenyTag(treeNetworkDataAdapter);
            }
            if (!((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).hasTreeGroupMetadata()) continue;
            this.getLogger().addWarning("No metadata for the tree or network group with the ID \"" + ((LinkedLabeledIDEvent)treeNetworkGroupDataAdapter.getStartEvent(this.getParameters())).getID() + "\" was written, because the PhyloXML format does not support this.");
        }
    }

    private void writePhylogenyTag(TreeNetworkDataAdapter treeNetworkDataAdapter) throws XMLStreamException, IOException {
        PhyloXMLMetaDataReceiver phyloXMLMetaDataReceiver = new PhyloXMLSpecificPredicatesDataReceiver((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), PropertyOwner.PHYLOGENY, IDENTIFIER_PHYLOGENY);
        LabeledIDEvent labeledIDEvent = (LabeledIDEvent)treeNetworkDataAdapter.getStartEvent(this.getParameters());
        TreeTopologyExtractor treeTopologyExtractor = new TreeTopologyExtractor(treeNetworkDataAdapter, this.getParameters());
        String string = treeTopologyExtractor.getPaintStartID();
        boolean bl = treeNetworkDataAdapter.getNodes(this.getParameters()).getObjectStartEvent(this.getParameters(), string).isRootNode();
        this.getXMLWriter().writeStartElement(TAG_PHYLOGENY.getLocalPart());
        this.getXMLWriter().writeAttribute(ATTR_ROOTED.getLocalPart(), Boolean.toString(bl));
        this.getXMLWriter().writeAttribute(ATTR_BRANCH_LENGTH_UNIT.getLocalPart(), XMLReadWriteUtils.getXSDPrefix(this.getXMLWriter()) + ":" + "double");
        this.writeSimpleTag(TAG_NAME.getLocalPart(), labeledIDEvent.getLabel());
        String string2 = ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPhylogenyID();
        if (string2 == null) {
            string2 = labeledIDEvent.getID();
        }
        this.getXMLWriter().writeStartElement(TAG_ID.getLocalPart());
        if (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPhylogenyIDProvider() != null) {
            this.getXMLWriter().writeAttribute(ATTR_ID_PROVIDER.getLocalPart(), ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPhylogenyIDProvider());
        }
        this.getXMLWriter().writeCharacters(string2);
        this.getXMLWriter().writeEndElement();
        treeNetworkDataAdapter.writeMetadata(this.getParameters(), phyloXMLMetaDataReceiver);
        this.writeCladeTag(treeNetworkDataAdapter, treeTopologyExtractor, string);
        for (String string3 : treeTopologyExtractor.getNetworkEdgeIDs()) {
            EdgeEvent edgeEvent = treeNetworkDataAdapter.getEdges(this.getParameters()).getObjectStartEvent(this.getParameters(), string3);
            this.getXMLWriter().writeStartElement(TAG_CLADE_RELATION.getLocalPart());
            this.getXMLWriter().writeAttribute(ATTR_ID_REF_0.getLocalPart(), ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getNodeEventIDToIDSourceMap().get(edgeEvent.getSourceID()));
            this.getXMLWriter().writeAttribute(ATTR_ID_REF_1.getLocalPart(), ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getNodeEventIDToIDSourceMap().get(edgeEvent.getTargetID()));
            this.getXMLWriter().writeAttribute(ATTR_DISTANCE.getLocalPart(), Double.toString(edgeEvent.getLength()));
            this.getXMLWriter().writeAttribute(ATTR_TYPE.getLocalPart(), "network_edge");
        }
        phyloXMLMetaDataReceiver = new PhyloXMLPropertyMetadataReceiver((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), PropertyOwner.PHYLOGENY);
        treeNetworkDataAdapter.writeMetadata(this.getParameters(), phyloXMLMetaDataReceiver);
        phyloXMLMetaDataReceiver = new PhyloXMLMetaDataReceiver((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), PropertyOwner.PHYLOGENY);
        treeNetworkDataAdapter.writeMetadata(this.getParameters(), phyloXMLMetaDataReceiver);
        phyloXMLMetaDataReceiver = new PhyloXMLOnlyCustomXMLDataReceiver((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), PropertyOwner.PHYLOGENY);
        treeNetworkDataAdapter.writeMetadata(this.getParameters(), phyloXMLMetaDataReceiver);
        this.getXMLWriter().writeEndElement();
    }

    private void writeCladeTag(TreeNetworkDataAdapter treeNetworkDataAdapter, TreeTopologyExtractor treeTopologyExtractor, String string) throws XMLStreamException, IOException {
        PhyloXMLMetaDataReceiver phyloXMLMetaDataReceiver = new PhyloXMLSpecificPredicatesDataReceiver((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), PropertyOwner.NODE, IDENTIFIER_NODE);
        PhyloXMLMetaDataReceiver phyloXMLMetaDataReceiver2 = new PhyloXMLSpecificPredicatesDataReceiver((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), PropertyOwner.PARENT_BRANCH, IDENTIFIER_EDGE);
        NodeEvent nodeEvent = treeNetworkDataAdapter.getNodes(this.getParameters()).getObjectStartEvent(this.getParameters(), string);
        EdgeEvent edgeEvent = treeNetworkDataAdapter.getEdges(this.getParameters()).getObjectStartEvent(this.getParameters(), treeTopologyExtractor.getIDToNodeInfoMap().get(string).getAfferentBranchID());
        this.getXMLWriter().writeStartElement(TAG_CLADE.getLocalPart());
        String string2 = ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getNodeEventIDToIDSourceMap().get(string);
        if (string2 != null) {
            this.getXMLWriter().writeAttribute(ATTR_ID_SOURCE.getLocalPart(), string2);
        } else {
            int n = 1;
            string2 = string;
            while (!((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getIdSources().add(string2)) {
                string2 = string + n;
                ++n;
            }
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getNodeEventIDToIDSourceMap().put(string, string2);
            this.getXMLWriter().writeAttribute(ATTR_ID_SOURCE.getLocalPart(), string2);
        }
        if (!Double.isNaN(edgeEvent.getLength())) {
            this.getXMLWriter().writeAttribute(ATTR_BRANCH_LENGTH.getLocalPart(), Double.toString(edgeEvent.getLength()));
        }
        this.writeSimpleTag(TAG_NAME.getLocalPart(), nodeEvent.getLabel());
        treeNetworkDataAdapter.getEdges(this.getParameters()).writeContentData(this.getParameters(), phyloXMLMetaDataReceiver2, edgeEvent.getID());
        treeNetworkDataAdapter.getNodes(this.getParameters()).writeContentData(this.getParameters(), phyloXMLMetaDataReceiver, string);
        phyloXMLMetaDataReceiver = new PhyloXMLMetaDataReceiver((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), PropertyOwner.NODE);
        phyloXMLMetaDataReceiver2 = new PhyloXMLMetaDataReceiver((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), PropertyOwner.PARENT_BRANCH);
        treeNetworkDataAdapter.getNodes(this.getParameters()).writeContentData(this.getParameters(), phyloXMLMetaDataReceiver, string);
        treeNetworkDataAdapter.getEdges(this.getParameters()).writeContentData(this.getParameters(), phyloXMLMetaDataReceiver2, edgeEvent.getID());
        for (String string3 : treeTopologyExtractor.getIDToNodeInfoMap().get(string).getChildNodeIDs()) {
            this.writeCladeTag(treeNetworkDataAdapter, treeTopologyExtractor, string3);
        }
        phyloXMLMetaDataReceiver = new PhyloXMLOnlyCustomXMLDataReceiver((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), PropertyOwner.NODE);
        phyloXMLMetaDataReceiver2 = new PhyloXMLOnlyCustomXMLDataReceiver((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider(), this.getParameters(), PropertyOwner.PARENT_BRANCH);
        treeNetworkDataAdapter.getNodes(this.getParameters()).writeContentData(this.getParameters(), phyloXMLMetaDataReceiver, string);
        treeNetworkDataAdapter.getEdges(this.getParameters()).writeContentData(this.getParameters(), phyloXMLMetaDataReceiver2, edgeEvent.getID());
        this.getXMLWriter().writeEndElement();
    }

    private void writeSimpleTag(String string, String string2) throws XMLStreamException {
        if (string2 != null && !string2.isEmpty()) {
            this.getXMLWriter().writeStartElement(string);
            this.getXMLWriter().writeCharacters(string2);
            this.getXMLWriter().writeEndElement();
        }
    }
}

