/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phylip;

import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.PartEndEvent;
import info.bioinfweb.jphyloio.events.SequenceTokensEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.formats.phylip.AbstractPhylipEventReader;
import info.bioinfweb.jphyloio.formats.text.TextReaderStreamDataProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class SequentialPhylipEventReader
extends AbstractPhylipEventReader<TextReaderStreamDataProvider<SequentialPhylipEventReader>> {
    private int charactersRead = Integer.MAX_VALUE;

    public SequentialPhylipEventReader(BufferedReader bufferedReader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(bufferedReader, readWriteParameterMap);
    }

    public SequentialPhylipEventReader(File file, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(file, readWriteParameterMap);
    }

    public SequentialPhylipEventReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(inputStream, readWriteParameterMap);
    }

    public SequentialPhylipEventReader(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(reader, readWriteParameterMap);
    }

    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.sequentialphylip";
    }

    @Override
    protected void readNextEvent() throws IOException {
        if (this.isBeforeFirstAccess()) {
            this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.DOCUMENT, EventTopologyType.START));
        } else {
            switch (this.getPreviousEvent().getType().getContentType()) {
                case DOCUMENT: {
                    if (!this.getPreviousEvent().getType().getTopologyType().equals((Object)EventTopologyType.START)) break;
                    this.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.ALIGNMENT, "matrix" + this.getIDManager().createNewID(), null, null));
                    this.readMatrixDimensions();
                    break;
                }
                case ALIGNMENT: {
                    this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.DOCUMENT, EventTopologyType.END));
                    break;
                }
                case LITERAL_META: {
                    if (this.getSequenceCount() == 0L) {
                        this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.ALIGNMENT, EventTopologyType.END));
                        break;
                    }
                }
                case SEQUENCE_TOKENS: {
                    JPhyloIOEvent jPhyloIOEvent;
                    if (this.lineConsumed) {
                        while (this.getReader().isNewLineNext()) {
                            this.getReader().consumeNewLine();
                        }
                        if ((long)this.charactersRead >= this.getCharacterCount()) {
                            this.currentSequenceName = this.readSequenceName();
                            this.charactersRead = 0;
                            if (!this.getPreviousEvent().getType().getContentType().equals((Object)EventContentType.LITERAL_META)) {
                                this.getCurrentEventCollection().add(new PartEndEvent(EventContentType.SEQUENCE, this.getSequenceTokensEventManager().getCurrentPosition() >= this.getCharacterCount()));
                            }
                            if (this.getReader().peek() != -1) {
                                this.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.SEQUENCE, "seq" + this.getIDManager().createNewID(), this.currentSequenceName, null));
                            }
                        }
                        if (this.getReader().peek() == -1) {
                            this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.ALIGNMENT, EventTopologyType.END));
                            break;
                        }
                    }
                    if ((jPhyloIOEvent = this.readCharacters(this.currentSequenceName)) == null) {
                        this.readNextEvent();
                        break;
                    }
                    this.getCurrentEventCollection().add(jPhyloIOEvent);
                    if (!EventContentType.SEQUENCE_TOKENS.equals((Object)jPhyloIOEvent.getType().getContentType())) break;
                    this.charactersRead += ((SequenceTokensEvent)jPhyloIOEvent).getTokens().size();
                    break;
                }
                default: {
                    throw new InternalError("Impossible case");
                }
            }
        }
    }
}

