/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phylip;

import info.bioinfweb.jphyloio.AbstractSingleMatrixEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.DocumentDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.MatrixDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.OTUListDataAdapter;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.formats.phylip.PhylipConstants;
import info.bioinfweb.jphyloio.formats.text.TextSequenceContentReceiver;
import info.bioinfweb.jphyloio.formats.text.TextWriterStreamDataProvider;
import java.io.IOException;
import java.util.Iterator;

public class PhylipEventWriter
extends AbstractSingleMatrixEventWriter<TextWriterStreamDataProvider<PhylipEventWriter>>
implements PhylipConstants {
    public PhylipEventWriter() {
        super("Phylip");
    }

    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.phylip";
    }

    @Override
    protected TextWriterStreamDataProvider<PhylipEventWriter> createStreamDataProvider() {
        return new TextWriterStreamDataProvider<PhylipEventWriter>(this);
    }

    public static String maskReservedPhylipLabelCharacters(String string) {
        return string.replace('(', '<').replace(')', '>').replace('[', '<').replace(']', '>').replace(':', '|').replace(';', '|').replace(',', '|');
    }

    @Override
    protected String maskReservedLabelCharacters(String string) {
        return PhylipEventWriter.maskReservedPhylipLabelCharacters(string);
    }

    @Override
    protected void writeSingleMatrix(DocumentDataAdapter documentDataAdapter, MatrixDataAdapter matrixDataAdapter, Iterator<String> iterator, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        int n = readWriteParameterMap.getInteger("info.bioinfweb.jphyloio.maximumNameLength", 10);
        String string = readWriteParameterMap.getString("info.bioinfweb.jphyloio.sequenceExtensionToken");
        long l = PhylipEventWriter.determineMaxSequenceLength(matrixDataAdapter, readWriteParameterMap);
        OTUListDataAdapter oTUListDataAdapter = null;
        LinkedLabeledIDEvent linkedLabeledIDEvent = (LinkedLabeledIDEvent)matrixDataAdapter.getStartEvent(readWriteParameterMap);
        if (linkedLabeledIDEvent.hasLink() && (oTUListDataAdapter = documentDataAdapter.getOTUList(readWriteParameterMap, linkedLabeledIDEvent.getLinkedID())) == null) {
            readWriteParameterMap.getLogger().addWarning("The matrix with the ID " + linkedLabeledIDEvent.getID() + " references an OTU list with the ID " + linkedLabeledIDEvent.getLinkedID() + ", but the document data adapter does not provide an OTU list with this ID. OTU references of writtes sequences will be ignored.");
        }
        this.getWriter().write("\t" + matrixDataAdapter.getSequenceCount(readWriteParameterMap) + "\t" + l);
        PhylipEventWriter.writeLineBreak(this.getWriter(), readWriteParameterMap);
        if (matrixDataAdapter.getColumnCount(readWriteParameterMap) == -1L && string == null) {
            readWriteParameterMap.getLogger().addWarning("The provided sequences have inequal lengths and filling up sequences was not specified. The column count written to the Phylip document is the length of the longest sequence. Some programs may not be able to parse Phylip files with unequal sequence lengths.");
        }
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            String string3 = this.editSequenceOrNodeLabel(matrixDataAdapter.getSequenceStartEvent(readWriteParameterMap, string2), readWriteParameterMap, oTUListDataAdapter);
            this.getWriter().write(string3);
            for (int i = string3.length(); i < n; ++i) {
                this.getWriter().write(32);
            }
            TextSequenceContentReceiver<TextWriterStreamDataProvider> textSequenceContentReceiver = new TextSequenceContentReceiver<TextWriterStreamDataProvider>((TextWriterStreamDataProvider)this.getStreamDataProvider(), readWriteParameterMap, matrixDataAdapter.containsLongTokens(readWriteParameterMap), null, null);
            matrixDataAdapter.writeSequencePartContentData(readWriteParameterMap, textSequenceContentReceiver, string2, 0L, matrixDataAdapter.getSequenceLength(readWriteParameterMap, string2));
            this.extendSequence(matrixDataAdapter, readWriteParameterMap, string2, l, string, textSequenceContentReceiver);
            PhylipEventWriter.writeLineBreak(this.getWriter(), readWriteParameterMap);
        }
    }
}

