/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phylip;

import info.bioinfweb.jphyloio.JPhyloIOEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.factory.AbstractSingleReaderWriterFactory;
import info.bioinfweb.jphyloio.factory.SingleReaderWriterFactory;
import info.bioinfweb.jphyloio.formatinfo.DefaultFormatInfo;
import info.bioinfweb.jphyloio.formatinfo.JPhyloIOFormatInfo;
import info.bioinfweb.jphyloio.formatinfo.MetadataModeling;
import info.bioinfweb.jphyloio.formatinfo.MetadataTopologyType;
import info.bioinfweb.jphyloio.formats.JPhyloIOFormatIDs;
import info.bioinfweb.jphyloio.formats.phylip.PhylipConstants;
import info.bioinfweb.jphyloio.formats.phylip.PhylipEventWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;

public abstract class AbstractPhylipFactory
extends AbstractSingleReaderWriterFactory
implements SingleReaderWriterFactory,
PhylipConstants,
JPhyloIOFormatIDs {
    public static final int MAXIMUM_EXPECTED_DIGITS_OR_WHITESPACE = 128;

    @Override
    public boolean checkFormat(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        for (int i = 0; i < 2; ++i) {
            int n;
            int n2 = 0;
            while ((n = reader.read()) != -1 && Character.isWhitespace(n) && ++n2 < 128) {
            }
            if (n == -1 || !Character.isDigit(n)) {
                return false;
            }
            n2 = 0;
            while ((n = reader.read()) != -1 && Character.isDigit(n) && ++n2 < 128) {
            }
            if (n != -1 && Character.isWhitespace(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JPhyloIOEventWriter getWriter() {
        return new PhylipEventWriter();
    }

    @Override
    public boolean hasReader() {
        return true;
    }

    @Override
    public boolean hasWriter() {
        return true;
    }

    protected JPhyloIOFormatInfo createFormatInfo(String string, String string2, Set<String> set, Set<String> set2, String string3) {
        EnumSet<EventContentType[]> enumSet = EnumSet.of(EventContentType.DOCUMENT, new EventContentType[]{EventContentType.LITERAL_META, EventContentType.LITERAL_META_CONTENT, EventContentType.ALIGNMENT, EventContentType.SEQUENCE, EventContentType.SEQUENCE_TOKENS});
        EnumSet<EventContentType[]> enumSet2 = EnumSet.copyOf(enumSet);
        enumSet2.add((EventContentType[])EventContentType.SINGLE_SEQUENCE_TOKEN);
        EnumMap<EventContentType, MetadataModeling> enumMap = new EnumMap<EventContentType, MetadataModeling>(EventContentType.class);
        enumMap.put(EventContentType.ALIGNMENT, new MetadataModeling(MetadataTopologyType.LITERAL_ONLY, EnumSet.of(LiteralContentSequenceType.SIMPLE)));
        return new DefaultFormatInfo(this, string, string2, enumSet, enumSet2, enumMap, Collections.emptyMap(), set, set2, new ReadWriteParameterMap(), string3, "phy", "phylip");
    }
}

