/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phylip;

import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.phylip.PhylipConstants;
import info.bioinfweb.jphyloio.formats.text.AbstractTextEventReader;
import info.bioinfweb.jphyloio.formats.text.TextReaderStreamDataProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public abstract class AbstractPhylipEventReader<P extends TextReaderStreamDataProvider<? extends AbstractPhylipEventReader<P>>>
extends AbstractTextEventReader<P>
implements PhylipConstants {
    private long sequenceCount = -1L;
    private long characterCount = -1L;
    protected String currentSequenceName = null;

    public AbstractPhylipEventReader(PeekReader peekReader, ReadWriteParameterMap readWriteParameterMap) {
        super(peekReader, readWriteParameterMap, readWriteParameterMap.getMatchToken());
    }

    public AbstractPhylipEventReader(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(reader, readWriteParameterMap, readWriteParameterMap.getMatchToken());
    }

    public AbstractPhylipEventReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(inputStream, readWriteParameterMap, readWriteParameterMap.getMatchToken());
    }

    public AbstractPhylipEventReader(File file, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(file, readWriteParameterMap, readWriteParameterMap.getMatchToken());
    }

    public boolean isRelaxedPhylip() {
        return this.getParameters().getBoolean("info.bioinfweb.jphyloio.relaxedPhylip", false);
    }

    protected long getSequenceCount() {
        return this.sequenceCount;
    }

    protected long getCharacterCount() {
        return this.characterCount;
    }

    protected void readMatrixDimensions() throws IOException {
        PeekReader.ReadResult readResult = this.getReader().readLine();
        if (!readResult.isCompletelyRead()) {
            throw new JPhyloIOReaderException("First line of Phylip file is too long. It does not seem to be a valid Phylip file.", (StreamLocationProvider)this.getReader());
        }
        String[] stringArray = readResult.getSequence().toString().trim().split("\\s+");
        if (stringArray.length == 2) {
            try {
                this.sequenceCount = Long.parseLong(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JPhyloIOReaderException("Invalid integer value \"" + stringArray[0] + "\" found for the Phylip sequence count.", (StreamLocationProvider)this.getReader(), (Throwable)numberFormatException);
            }
            this.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + ((TextReaderStreamDataProvider)this.getStreamDataProvider()).getIDManager().createNewID(), null, new URIOrStringIdentifier(null, PREDICATE_SEQUENCE_COUNT), LiteralContentSequenceType.SIMPLE));
            this.getCurrentEventCollection().add(new LiteralMetadataContentEvent(this.sequenceCount, stringArray[0]));
            this.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
            try {
                this.characterCount = Long.parseLong(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JPhyloIOReaderException("Invalid integer value \"" + stringArray[1] + "\" found for the Phylip character count.", (StreamLocationProvider)this.getReader(), (Throwable)numberFormatException);
            }
        }
        throw new JPhyloIOReaderException("The first line of a Phylip file needs to contain exactly two integer values spcifying the sequence and character count. " + stringArray.length + " value(s) was/were found instead.", (StreamLocationProvider)this.getReader());
        this.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + ((TextReaderStreamDataProvider)this.getStreamDataProvider()).getIDManager().createNewID(), null, new URIOrStringIdentifier(null, PREDICATE_CHARACTER_COUNT), LiteralContentSequenceType.SIMPLE));
        this.getCurrentEventCollection().add(new LiteralMetadataContentEvent(this.characterCount, stringArray[1]));
        this.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
    }

    protected String readSequenceName() throws IOException {
        String string = this.isRelaxedPhylip() ? this.getReader().readRegExp(RELAXED_PHYLIP_NAME_PATTERN, true).getSequence().toString().trim() : this.getReader().readUntil(10, "\t").getSequence().toString().trim();
        return string;
    }
}

