/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.receivers;

import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.SingleTokenDefinitionEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.exception.IllegalEventException;
import info.bioinfweb.jphyloio.formats.nexus.NexusEventWriter;
import info.bioinfweb.jphyloio.formats.nexus.NexusWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.receivers.AbstractNexusEventReceiver;
import java.io.IOException;

public class TokenSetEventReceiver
extends AbstractNexusEventReceiver {
    private StringBuilder singleTokens = new StringBuilder();

    public TokenSetEventReceiver(NexusWriterStreamDataProvider nexusWriterStreamDataProvider) {
        super(nexusWriterStreamDataProvider);
    }

    public String getSingleTokens() {
        if (this.singleTokens.length() > 0) {
            return this.singleTokens.toString();
        }
        return null;
    }

    public void clear() {
        this.singleTokens.delete(0, this.singleTokens.length());
    }

    private void writeSingleTokenDefinition(String string, SingleTokenDefinitionEvent singleTokenDefinitionEvent) throws IOException {
        ((NexusWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().write(32);
        NexusEventWriter.writeKeyValueExpression(((NexusWriterStreamDataProvider)this.getStreamDataProvider()).getWriter(), string, NexusEventWriter.formatToken(singleTokenDefinitionEvent.getTokenName()));
    }

    @Override
    protected boolean doAdd(JPhyloIOEvent jPhyloIOEvent) throws IllegalArgumentException, IOException {
        if (jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.SINGLE_TOKEN_DEFINITION) && this.getParentEvent() == null) {
            if (jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.START)) {
                SingleTokenDefinitionEvent singleTokenDefinitionEvent = jPhyloIOEvent.asSingleTokenDefinitionEvent();
                switch (singleTokenDefinitionEvent.getMeaning()) {
                    case CHARACTER_STATE: {
                        if (this.singleTokens.length() > 0) {
                            this.singleTokens.append(" ");
                        }
                        this.singleTokens.append(singleTokenDefinitionEvent.getTokenName());
                        break;
                    }
                    case GAP: {
                        this.writeSingleTokenDefinition("GAP", singleTokenDefinitionEvent);
                        break;
                    }
                    case MISSING: {
                        this.writeSingleTokenDefinition("MISSING", singleTokenDefinitionEvent);
                        break;
                    }
                    case MATCH: {
                        this.writeSingleTokenDefinition("MATCHCHAR", singleTokenDefinitionEvent);
                        break;
                    }
                }
            }
            return true;
        }
        if (jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.CHARACTER_SET_INTERVAL) && this.getParentEvent() == null) {
            return true;
        }
        throw IllegalEventException.newInstance(this, this.getParentEvent(), jPhyloIOEvent);
    }
}

