/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders.taxa;

import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.LabeledIDEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.AbstractNexusCommandEventReader;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;

public class TaxLabelsReader
extends AbstractNexusCommandEventReader
implements NexusConstants,
ReadWriteConstants {
    private boolean beforeStart = true;
    private String currentListID;

    public TaxLabelsReader(NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super("TAXLABELS", new String[]{"TAXA"}, nexusReaderStreamDataProvider);
    }

    @Override
    protected boolean doReadNextEvent() throws IOException {
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        try {
            if (this.beforeStart) {
                this.beforeStart = false;
                this.currentListID = "otus" + this.getStreamDataProvider().getIDManager().createNewID();
                String string = this.getStreamDataProvider().getSharedInformationMap().getString("info.bioinfweb.jphyloio.nexus.blockTitle");
                if (!this.getStreamDataProvider().getBlockTitleToIDMap().hasDefaultBlockID("TAXA")) {
                    this.getStreamDataProvider().getBlockTitleToIDMap().putDefaultBlockID("TAXA", this.currentListID);
                }
                if (string != null) {
                    this.getStreamDataProvider().getBlockTitleToIDMap().putID("TAXA", string, this.currentListID);
                }
                Collection<JPhyloIOEvent> collection = this.getStreamDataProvider().resetCurrentEventCollection();
                this.getStreamDataProvider().getCurrentEventCollection().add(new LabeledIDEvent(EventContentType.OTU_LIST, this.currentListID, string));
                this.getStreamDataProvider().getCurrentEventCollection().addAll(collection);
                return true;
            }
            this.getStreamDataProvider().consumeWhiteSpaceAndComments();
            char c = peekReader.peekChar();
            if (c == ';') {
                peekReader.skip(1L);
                this.setAllDataProcessed(true);
                return false;
            }
            String string = this.getStreamDataProvider().readNexusWord();
            String string2 = "otu" + this.getStreamDataProvider().getIDManager().createNewID();
            this.getStreamDataProvider().getElementList(EventContentType.OTU, this.currentListID).add(string);
            this.getStreamDataProvider().getNexusNameToIDMap(EventContentType.OTU, this.currentListID).put(string, string2);
            this.getStreamDataProvider().getCurrentEventCollection().add(new LabeledIDEvent(EventContentType.OTU, string2, string));
            this.getStreamDataProvider().getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.OTU, EventTopologyType.END));
            return true;
        }
        catch (EOFException eOFException) {
            throw new JPhyloIOReaderException("Unexpected end of file in " + this.getCommandName() + " command.", (StreamLocationProvider)peekReader);
        }
    }
}

