/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders.sets;

import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.events.SetElementEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.sets.AbstractNexusSetReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class IDBasedSetsReader
extends AbstractNexusSetReader
implements NexusConstants,
ReadWriteConstants {
    private String linkedBlockTypeName;
    private EventContentType elementType;

    public IDBasedSetsReader(EventContentType eventContentType, String string, String string2, EventContentType eventContentType2, NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super(eventContentType, string, new String[]{"SETS"}, nexusReaderStreamDataProvider);
        this.linkedBlockTypeName = string2;
        this.elementType = eventContentType2;
    }

    @Override
    protected String getLinkedID() {
        return this.getStreamDataProvider().getCurrentLinkedBlockID(this.linkedBlockTypeName);
    }

    @Override
    protected long getElementCount() {
        return this.getStreamDataProvider().getElementList(this.elementType, this.getLinkedID()).size();
    }

    @Override
    protected void createEventsForInterval(long l, long l2) throws IOException {
        if (l2 > Integer.MAX_VALUE) {
            throw new JPhyloIOReaderException("This reader implementation does not support taxon sets in Nexus files that contain more than 2147483647 elements.", (StreamLocationProvider)this.getStreamDataProvider().getDataReader());
        }
        List<String> list = this.getStreamDataProvider().getElementList(this.elementType, this.getLinkedID());
        Map<String, String> map = this.getStreamDataProvider().getNexusNameToIDMap(this.elementType, this.getLinkedID());
        int n = (int)l;
        while ((long)n < l2) {
            this.getStreamDataProvider().getCurrentEventCollection().add(new SetElementEvent(map.get(list.get(n)), this.elementType));
            ++n;
        }
    }

    @Override
    protected long elementIndexByName(String string) {
        return this.getStreamDataProvider().getElementList(this.elementType, this.getLinkedID()).indexOf(string);
    }
}

