/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders.sets;

import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.commons.text.StringUtils;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.PartEndEvent;
import info.bioinfweb.jphyloio.events.SetElementEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.exception.UnsupportedFormatFeatureException;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.AbstractNexusCommandEventReader;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractNexusSetReader
extends AbstractNexusCommandEventReader
implements NexusConstants,
ReadWriteConstants {
    private static final String NULL_LINKED_ID = "$$$$$";
    private EventContentType setType;
    private String name = null;
    private boolean isVectorFormat = false;
    private long currentColumn = 0L;

    public AbstractNexusSetReader(EventContentType eventContentType, String string, String[] stringArray, NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super(string, stringArray, nexusReaderStreamDataProvider);
        this.setType = eventContentType;
    }

    protected abstract String getLinkedID();

    protected abstract long getElementCount();

    protected abstract void createEventsForInterval(long var1, long var3) throws IOException;

    protected abstract long elementIndexByName(String var1);

    private boolean checkFormatName(PeekReader peekReader, String string) {
        return peekReader.peekString(string.length()).toUpperCase().equals(string);
    }

    private String getKeyFromLinkedID() {
        String string = this.getLinkedID();
        if (string == null) {
            string = NULL_LINKED_ID;
        }
        return string;
    }

    private void addStartEvent(String string) throws IOException {
        LinkedLabeledIDEvent linkedLabeledIDEvent = new LinkedLabeledIDEvent(this.setType, "id" + this.getStreamDataProvider().getIDManager().createNewID(), string, this.getLinkedID());
        this.getStreamDataProvider().getCurrentEventCollection().add(linkedLabeledIDEvent);
        this.getStreamDataProvider().getNexusNameToIDMap(this.setType, this.getKeyFromLinkedID()).put(linkedLabeledIDEvent.getLabel(), linkedLabeledIDEvent.getID());
    }

    private boolean readNameAndFormat() throws IOException {
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        this.getStreamDataProvider().consumeWhiteSpaceAndComments();
        this.name = this.getStreamDataProvider().readNexusWord();
        if (this.name.length() == 0) {
            throw new JPhyloIOReaderException("Unexpected end of file in a Nexus CHARSET command.", (StreamLocationProvider)peekReader);
        }
        char c = peekReader.readChar();
        if (c == '[') {
            this.getStreamDataProvider().readComment();
        } else {
            if (c == ';') {
                this.setAllDataProcessed(true);
                if (this.name.length() > 1) {
                    this.addStartEvent(StringUtils.cutEnd((String)this.name, (int)1));
                    this.getStreamDataProvider().getCurrentEventCollection().add(new PartEndEvent(this.setType, true));
                    return true;
                }
                throw new JPhyloIOReaderException("Empty Nexus CHARSET command. At least a set name must be specified.", (StreamLocationProvider)peekReader);
            }
            if (c != '=') {
                this.getStreamDataProvider().consumeWhiteSpaceAndComments();
                this.isVectorFormat = false;
                if (this.checkFormatName(peekReader, "STANDARD")) {
                    peekReader.skip((long)"STANDARD".length());
                } else if (this.checkFormatName(peekReader, "VECTOR")) {
                    this.isVectorFormat = true;
                    peekReader.skip((long)"VECTOR".length());
                }
                this.getStreamDataProvider().consumeWhiteSpaceAndComments();
                char c2 = peekReader.readChar();
                if (c2 == ';') {
                    this.setAllDataProcessed(true);
                    this.addStartEvent(this.name);
                    this.getStreamDataProvider().getCurrentEventCollection().add(new PartEndEvent(this.setType, true));
                    return true;
                }
                if (c2 != '=') {
                    throw new JPhyloIOReaderException("Unexpected token '" + c2 + "' found in CharSet command.", (StreamLocationProvider)peekReader);
                }
            }
        }
        this.addStartEvent(this.name);
        return false;
    }

    private JPhyloIOReaderException createUnknownElementCountException(PeekReader peekReader) {
        return new JPhyloIOReaderException("A set was referencing the maximum index (using '.'), which could not be determined. A possible cause can be that no block containing the set elements (e.g. TAXA or CHARACTERS) was previously defined.", (StreamLocationProvider)peekReader);
    }

    private long readIndex(String string, long l) {
        if (string.equals(Character.toString('.'))) {
            return l;
        }
        long l2 = this.elementIndexByName(string);
        if (l2 == -1L) {
            try {
                l2 = Long.parseLong(string) - 1L;
            }
            catch (NumberFormatException numberFormatException) {
                return -1L;
            }
        }
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readStandardFormat() throws IOException {
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        long l = -1L;
        ArrayList<JPhyloIOEvent> arrayList = new ArrayList<JPhyloIOEvent>();
        long l2 = this.getElementCount() - 1L;
        try {
            long l3;
            if (peekReader.isNext("ALL")) {
                peekReader.skip((long)"ALL".length());
                if (l2 < 0L) {
                    throw this.createUnknownElementCountException(peekReader);
                }
                l3 = 0L;
                l = l2;
            } else {
                if (peekReader.isNext("REMAINING")) {
                    throw new UnsupportedFormatFeatureException("The encountered keyword REMAINING is currently not supported in JPhyloIO.", (StreamLocationProvider)peekReader);
                }
                String string = this.getStreamDataProvider().readNexusWord();
                l3 = this.readIndex(string, -2L);
                if (l3 == -2L) {
                    throw new JPhyloIOReaderException("The placeholder '.' is not allowed as the first index of an interval in a Nexus set defintion.", (StreamLocationProvider)peekReader);
                }
                if (l3 == -1L) {
                    String string2 = this.getStreamDataProvider().getNexusNameToIDMap(this.setType, this.getKeyFromLinkedID()).get(string);
                    if (string2 == null) throw new JPhyloIOReaderException("The token \"" + string + "\" could not be recognized as an element of this set or a reference to another set of the same type.", (StreamLocationProvider)peekReader);
                    this.getStreamDataProvider().getCurrentEventCollection().add(new SetElementEvent(string2, this.setType));
                    this.consumeWhiteSpaceAndCommentsToBuffer(arrayList);
                    if (peekReader.peekChar() == '\\') {
                        throw new UnsupportedFormatFeatureException("Specifying regular intervals for a referenced Nexus set (using '\\') is currently not supported by this reader.", (StreamLocationProvider)peekReader);
                    }
                } else {
                    this.consumeWhiteSpaceAndCommentsToBuffer(arrayList);
                    l = l3;
                    if (peekReader.peekChar() == '-') {
                        peekReader.skip(1L);
                        this.consumeWhiteSpaceAndCommentsToBuffer(arrayList);
                        string = this.getStreamDataProvider().readNexusWord();
                        l = this.readIndex(string, l2);
                        if (l == -1L) {
                            throw this.createUnknownElementCountException(peekReader);
                        }
                        this.consumeWhiteSpaceAndCommentsToBuffer(arrayList);
                    }
                }
            }
            if (l3 >= 0L) {
                if (peekReader.peekChar() == '\\') {
                    peekReader.skip(1L);
                    this.consumeWhiteSpaceAndCommentsToBuffer(arrayList);
                    long l4 = this.getStreamDataProvider().readPositiveInteger(-1L);
                    if (l == -2L) {
                        throw this.createUnknownElementCountException(peekReader);
                    }
                    if (l4 < 0L) {
                        throw new JPhyloIOReaderException("Unexpected token found in Nexus set definition.", (StreamLocationProvider)peekReader);
                    }
                    for (long i = l3; i <= l; i += l4) {
                        this.createEventsForInterval(i, i + 1L);
                    }
                } else {
                    this.createEventsForInterval(l3, l + 1L);
                }
            }
            this.getStreamDataProvider().getCurrentEventCollection().addAll(arrayList);
            return;
        }
        catch (EOFException eOFException) {
            throw new JPhyloIOReaderException("Unexpected end of file inside a set definition.", (StreamLocationProvider)peekReader, (Throwable)eOFException);
        }
    }

    private void readVectorFormat() throws IOException {
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        Collection<JPhyloIOEvent> collection = this.getStreamDataProvider().getCurrentEventCollection();
        char c = peekReader.readChar();
        long l = -1L;
        while (c != ';') {
            if (!Character.isWhitespace(c)) {
                switch (c) {
                    case '[': {
                        if (l != -1L) {
                            this.createEventsForInterval(l, this.currentColumn);
                        }
                        this.getStreamDataProvider().readComment();
                        return;
                    }
                    case '1': {
                        if (l == -1L) {
                            l = this.currentColumn;
                        }
                        ++this.currentColumn;
                        break;
                    }
                    case '0': {
                        ++this.currentColumn;
                        if (l == -1L) break;
                        this.createEventsForInterval(l, this.currentColumn - 1L);
                        return;
                    }
                    default: {
                        throw new JPhyloIOReaderException("Invalid CHARSET vector symbol '" + c + "' found.", (StreamLocationProvider)peekReader);
                    }
                }
            }
            c = peekReader.readChar();
        }
        this.setAllDataProcessed(true);
        if (l != -1L) {
            this.createEventsForInterval(l, this.currentColumn);
        }
        collection.add(new PartEndEvent(this.setType, true));
    }

    @Override
    protected boolean doReadNextEvent() throws IOException {
        boolean bl;
        int n = this.getStreamDataProvider().getCurrentEventCollection().size();
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        boolean bl2 = bl = this.name == null;
        if (bl && this.readNameAndFormat()) {
            return true;
        }
        this.getStreamDataProvider().consumeWhiteSpaceAndComments();
        int n2 = peekReader.peek();
        if (n2 == -1) {
            throw new JPhyloIOReaderException("Unexpected end of file in Nexus CHARSET command.", (StreamLocationProvider)peekReader);
        }
        if ((char)n2 == ';') {
            peekReader.skip(1L);
            this.setAllDataProcessed(true);
            this.getStreamDataProvider().getCurrentEventCollection().add(new PartEndEvent(this.setType, true));
            return bl;
        }
        if (this.isVectorFormat) {
            this.readVectorFormat();
        } else {
            this.readStandardFormat();
        }
        this.getStreamDataProvider().consumeWhiteSpaceAndComments();
        return n < this.getStreamDataProvider().getCurrentEventCollection().size();
    }
}

